% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-distinct.R
\name{distinct_all}
\alias{distinct_all}
\alias{distinct_at}
\alias{distinct_if}
\title{Select distinct rows by a selection of variables}
\usage{
distinct_all(.tbl, .funs = list(), ...)

distinct_at(.tbl, .vars, .funs = list(), ...)

distinct_if(.tbl, .predicate, .funs = list(), ...)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{A function \code{fun}, a quosure style lambda \code{~ fun(.)} or a list of either form.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:tidy-dots]{tidy dots} support.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}
}
\description{
These \link{scoped} variants of \code{\link[=distinct]{distinct()}} extract distinct rows by a
selection of variables. Like \code{distinct()}, you can modify the
variables before ordering with the \code{.funs} argument.
}
\section{Grouping variables}{


The grouping variables that are part of the selection are taken
into account to determine distinct rows.
}

\examples{
df <- tibble(x = rep(2:5, each = 2) / 2, y = rep(2:3, each = 4) / 2)
df
distinct_all(df)
distinct_at(df, vars(x,y))
distinct_if(df, is.numeric)

# You can supply a function that will be applied before extracting the distinct values
# The variables of the sorted tibble keep their original values.
distinct_all(df, round)
arrange_all(df, list(~round(.)))
}
