% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_when.R
\name{case_when}
\alias{case_when}
\title{A general vectorised if.}
\usage{
case_when(...)
}
\arguments{
\item{...}{A sequence of two-sided formulas. The left hand side (LHS)
  determines which values match this case. The right hand side (RHS)
  provides the replacement value.

  The LHS must evaluate to a logical vector. Each logical vector can
  either have length 1 or a common length. All RHSs must evaluate to
  the same type of vector.}
}
\value{
A vector as long as the longest LHS, with the type (and
  attributes) of the first RHS.  Inconsistent lengths of types will
  generate an error.
}
\description{
This function allows you to vectorise mutiple \code{if} and \code{else if}
statements. It is an R equivalent of the SQL \code{CASE WHEN} statement.
}
\examples{
x <- 1:50
case_when(
  x \%\% 35 == 0 ~ "fizz buzz",
  x \%\% 5 == 0 ~ "fizz",
  x \%\% 7 == 0 ~ "buzz",
  TRUE ~ as.character(x)
)

# Like an if statement, the arguments are evaluated in order, so you must
# proceed from the most specific to the most general. This won't work:
case_when(
  TRUE ~ as.character(x),
  x \%\%  5 == 0 ~ "fizz",
  x \%\%  7 == 0 ~ "buzz",
  x \%\% 35 == 0 ~ "fizz buzz"
)
}

