% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dpcr_density_table.R
\name{dpcr_density_table}
\alias{dpcr_density_table}
\title{Calculate Density of Multiple dPCR runs}
\usage{
dpcr_density_table(input, average = FALSE, methods = "wilson",
  conf.level = 0.95)
}
\arguments{
\item{input}{an object of class \code{\linkS4class{dpcr}}.}

\item{average}{If \code{TRUE}, calculates density of the average number of
molecules per partition. If \code{FALSE}, instead performs calculations for
the total number of positive molecules.}

\item{methods}{Method for calculating the confidence interval. 
Possible values are: \code{"wilson"}, \code{"agresti-coull"},
\code{"exact"}, \code{"prop.test"}, \code{"profile"}, \code{"lrt"},
\code{"asymptotic"}, \code{"bayes"}, \code{"cloglog"}, \code{"logit"},
\code{"probit"}. Default value is \code{"wilson"}. See Details.}

\item{conf.level}{The level of confidence to be used in the confidence
interval. Values from 0 to 1 and -1 to 0 are acceptable.}
}
\value{
A list (with the length equal to the number of runs in \code{input}) of 
data frames containing densities and borders of confidence intervals.
}
\description{
Calculates the density of the number of positive molecules or the average number 
of molecules per partition of \code{\link{dpcr}} objects.
}
\examples{
dens <- dpcr_density_table(six_panels)

# create plot using ggplot2
library(ggplot2)

ggplot(dens[["Experiment2.2"]], aes(x = x, y = y)) + 
  geom_line() + 
  geom_area(aes(fill = !(conf_up | conf_low))) +
  scale_y_continuous("Density") +
  scale_fill_discrete("0.95 CI")

}
\seealso{
\code{\link{dpcr_density}} for easy analysis and plots of single runs.
}
\author{
Michal Burdukiewicz, Stefan Roediger.
}
\keyword{dplot}
\keyword{hplot}
