% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotClustersAndLoess.R
\name{plotClustersAndLoess}
\alias{plotClustersAndLoess}
\title{Plot the log10-transformed barcode frequencies and the moving averages (LOESS)}
\usage{
plotClustersAndLoess(selected_clusters, output_directory, input_name)
}
\arguments{
\item{selected_clusters}{A dataframe containing the clusters from a hierarchical clustering
for a specific threshold}

\item{output_directory}{A string specifying the directory where plots will be saved.}

\item{input_name}{A string used as the base name for output files (e.g., "replicate1").}
}
\value{
No return value. This function saves plots and CSV files related to barcode cluster dynamics.
}
\description{
This file contains multiple functions. The main function is: plot_clusters_and_loess()
and it uses plotClusterLog10() and apply_LOESS(). In plot_clusters_and_loess(),
we plot the log10-transformed barcode frequencies contained in all selected clusters,
we compute a moving average per cluster and group them in a plot. We also write the files associated with
these two plots.
}
\examples{
\donttest{
# Load demo barcode count data (installed with the package)
demo_file <- system.file("extdata", "demo_input.csv", package = "doblin")
input_dataframe <- readr::read_csv(demo_file, show_col_types = FALSE)

# Filter data to retain dominant and persistent barcodes
filtered_df <- filterData(
  input_df = input_dataframe,
  freq_threshold = 0.00005,
  time_threshold = 5,
  output_directory = tempdir(),
  input_name = "demo"
)

# Perform hierarchical clustering using Pearson correlation
cluster_assignments <- performHClustering(
  filtered_data = filtered_df,
  agglomeration_method = "average",
  similarity_metric = "pearson",
  output_directory = tempdir(),
  input_name = "demo",
  missing_values = "pairwise.complete.obs",
  dtw_norm = NULL
)

# Filter clusters to retain only those with at least 8 members,
# unless they contain a dominant lineage
filtered_clusters <- filterHC(
  series_filtered = filtered_df,
  clusters = cluster_assignments,
  n_members = 8,
  min_freq_ignored_clusters = 0.0001
)


# Plot log10-transformed barcode frequencies and smoothed LOESS average per cluster
plotClustersAndLoess(
  selected_clusters = filtered_clusters,
  output_directory = tempdir(),
  input_name = "demo"
)
}
}
