% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dEnricherView.r
\name{dEnricherView}
\alias{dEnricherView}
\title{Function to view enrichment results of dEnricher}
\usage{
dEnricherView(eTerm, top_num = 10, sortBy = c("adjp", "pvalue",
"zscore",
"nAnno", "nOverlap", "none"), decreasing = NULL, details = F)
}
\arguments{
\item{eTerm}{an object of class "eTerm"}

\item{top_num}{the maximum number of gene sets (terms) will be viewed}

\item{sortBy}{which statistics will be used for sorting and viewing
gene sets (terms). It can be "adjp" for adjusted p value, "pvalue" for
p value, "zscore" for enrichment z-score, "nAnno" for the number of
sets (terms), "nOverlap" for the number in overlaps, and "none" for
ordering according to ID of gene sets (terms)}

\item{decreasing}{logical to indicate whether to sort in a decreasing
order. If it is null, it would be true for "zscore", "nAnno" or
"nOverlap"; otherwise it would be false}

\item{details}{logical to indicate whether the detailed information of
gene sets (terms) is also viewed. By default, it sets to false for no
inclusion}
}
\value{
a data frame with following components:
\itemize{
\item{\code{setID}: term ID; as rownames}
\item{\code{name}: term name}
\item{\code{nAnno}: number in gene members annotated by a term}
\item{\code{nOverlap}: number in overlaps}
\item{\code{zscore}: enrichment z-score}
\item{\code{pvalue}: nominal p value}
\item{\code{adjp}: adjusted p value}
\item{\code{namespace}: term namespace; optional, it is only appended
when "details" is true}
\item{\code{distance}: term distance; optional, it is only appended
when "details" is true}
\item{\code{members}: members (represented as Gene Symbols) in
overlaps; optional, it is only appended when "details" is true}
}
}
\description{
\code{dEnricherView} is supposed to view results of enrichment analysis
by \code{\link{dEnricher}}.
}
\note{
none
}
\examples{
#dEnricherView(eTerm, top_num=10, sortBy="adjp", decreasing=FALSE, details=TRUE)
}
\seealso{
\code{\link{dEnricher}}
}

