% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visNetArc.r
\name{visNetArc}
\alias{visNetArc}
\title{Function to visualise an igraph object via arc diagram}
\usage{
visNetArc(g, orientation = c("vertical", "horizontal"), newpage = T,
ordering = NULL, labels = V(g)$name, vertex.label.color = "black",
vertex.label.cex = 1, vertex.color = "transparent",
vertex.frame.color = "black", vertex.size = log(degree(g)) + 0.1,
vertex.pch = 21, vertex.lwd = 1, edge.color = "grey", edge.width = 1,
edge.lty = 1, ...)
}
\arguments{
\item{g}{an object of class "igraph"}

\item{orientation}{the orientation of the plots. It can be either
"vertical" (default) or "horizontal"}

\item{newpage}{logical to indicate whether to open a new page. By
default, it sets to true for opening a new page}

\item{ordering}{a numeric vector about the ordering of vertices. It is
optional. It is highly recommend to order vertices according to
communities and degrees}

\item{labels}{the label of the vertices. The default vertex labels are
the name attribute of the nodes}

\item{vertex.label.color}{the color of vertex labels}

\item{vertex.label.cex}{the font size of vertex labels}

\item{vertex.color}{the fill color of the vertices. The default vertex
colors are transparent}

\item{vertex.frame.color}{the color of the frame of the vertices. The
default vertex frame colors are black}

\item{vertex.size}{the size of each vertex. By default, it is decided
according to node degrees}

\item{vertex.pch}{the shape of each vertex. Either an integer
specifying a symbol or a single character to be used as the default in
plotting points. See
\url{http://www.statmethods.net/advgraphs/parameters.html}}

\item{vertex.lwd}{line width for the vertices (default 1)}

\item{edge.color}{the color of the edges (default "grey")}

\item{edge.width}{line width for the edges (default 1)}

\item{edge.lty}{line type for the edges (default 1)}

\item{...}{additional graphic parameters associated with 'mtext'}
}
\value{
invisible
}
\description{
\code{visNetArc} is supposed to visualise a graph object of class
"igraph" via arc diagram in one-dimensional layout. More precisely, it
displays vertices (nodes) along an axis, with edges linked by arcs.
With proper ordering of vertices (e.g. according to communities and
degrees), arc diagram is able to identify clusters and bridges (as
effective as two-dimensional layout). One advantage of using arc
diagram is to allow for easy annotations along vertices.
}
\note{
none
}
\examples{
# 1) generate a random graph according to the ER model
g <- erdos.renyi.game(100, 1/80)

# 2) produce the induced subgraph only based on the nodes in query
g <- dNetInduce(g, V(g), knn=0)

# 3) color nodes according to communities identified via a spin-glass model and simulated annealing
com <- spinglass.community(g, spins=4)
vgroups <- com$membership
palette.name <- visColormap(colormap="rainbow")
vcolors <- palette.name(length(com))[vgroups]

# 4) size nodes according to degrees
vdegrees <- igraph::degree(g)

# 5) sort nodes: first by communities and then degrees
tmp <- data.frame(ind=1:vcount(g), vgroups, vdegrees)
ordering <- tmp[order(vgroups,vdegrees),]$ind

# 6) visualise graph using 1-dimensional arc diagram
visNetArc(g, ordering=ordering, labels=V(g)$name,
vertex.label.color=vcolors,
vertex.color=vcolors, vertex.frame.color=vcolors,
vertex.size=log(vdegrees)+0.1)

# 7) as comparison, also visualise graph on 2-dimensional layout 
visNet(g, colormap="bwr", layout=layout.kamada.kawai(g),
vertex.label=V(g)$name,
vertex.color=vcolors, vertex.frame.color=vcolors,
vertex.shape="sphere")
}
\seealso{
\code{\link{visNet}}
}

