% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZTPoisson.R
\name{dztpois}
\alias{dztpois}
\alias{pztpois}
\alias{qztpois}
\alias{rztpois}
\title{The zero-truncated Poisson distribution}
\usage{
dztpois(x, lambda, log = FALSE)

pztpois(q, lambda, lower.tail = TRUE, log.p = FALSE)

qztpois(p, lambda, lower.tail = TRUE, log.p = FALSE)

rztpois(n, lambda)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{lambda}{vector of (non-negative) Poisson parameters.}

\item{log, log.p}{logical indicating whether probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical indicating whether probabilities are \eqn{P[X \le x]} (lower tail) or \eqn{P[X > x]} (upper tail).}

\item{p}{vector of probabilities.}

\item{n}{number of random values to return.}
}
\description{
Density, distribution function, quantile function, and random
generation for the zero-truncated Poisson distribution with
parameter \code{lambda}.
}
\details{
The Poisson distribution left-truncated at zero (or zero-truncated
Poisson for short) is the distribution obtained, when considering
a Poisson variable Y conditional on Y being greater than zero.

All functions follow the usual conventions of d/p/q/r functions
in base R. In particular, all four \code{ztpois} functions for the
zero-truncated Poisson distribution call the corresponding \code{pois}
functions for the Poisson distribution from base R internally.
}
\examples{
## theoretical probabilities for a zero-truncated Poisson distribution
x <- 0:8
p <- dztpois(x, lambda = 2.5)
plot(x, p, type = "h", lwd = 2)

## corresponding empirical frequencies from a simulated sample
set.seed(0)
y <- rztpois(500, lambda = 2.5)
hist(y, breaks = -1:max(y) + 0.5)

}
\seealso{
\code{\link{ZTPoisson}}, \code{\link{dpois}}
}
\keyword{distribution}
