% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gumbel.R
\name{quantile.Gumbel}
\alias{quantile.Gumbel}
\title{Determine quantiles of a Gumbel distribution}
\usage{
\method{quantile}{Gumbel}(x, probs, ...)
}
\arguments{
\item{x}{A \code{Gumbel} object created by a call to \code{\link[=Gumbel]{Gumbel()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Gumbel(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
