% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frechet.R
\name{quantile.Frechet}
\alias{quantile.Frechet}
\title{Determine quantiles of a Frechet distribution}
\usage{
\method{quantile}{Frechet}(x, probs, ...)
}
\arguments{
\item{x}{A \code{Frechet} object created by a call to \code{\link[=Frechet]{Frechet()}}.}

\item{probs}{A vector of probabilities.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{probs}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Frechet(0, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
