% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.dist.R
\name{get.dist}
\alias{get.dist}
\title{Get distribution data for your species list.}
\usage{
get.dist(x, input = FALSE, output = "list", matrix.res = "TK25")
}
\arguments{
\item{x}{A \code{data.frame} with one column containing the species names
in the format 'genus_epithet'.}

\item{input}{logical. If \code{TRUE x} is treated as the output of \code{check_species},
if \code{FALSE x} is treated as the input for \code{check_species} with
\code{level = "species"}}

\item{output}{A character string describing whether the output format should
be a \code{"list"} or a \code{"matrix"}.}

\item{matrix.res}{A character string describing the resolution of the produced
\code{matrix}, either \code{"TK25"} or \code{"quarterTK"}.}
}
\value{
Output depends on the \code{output} value. \code{output = "list"}
returns a \code{list} of one \code{data.frame} per taxon, including all
information found in the FloraWeb for the particular taxa. \code{output= "matrix"}
returns a presence/absence matrix for the TK25 plane survey sheets, when
\code{matrix.res = "TK25"} or the quarter TK25 plane survey sheets, when
\code{matrix.res = "quarterTK"} including every matching taxon in \code{x}.
}
\description{
This function downloads distribution data from the FloraWeb-database.
}
\details{
This function applies functions from the get.dist-family on your species
 list, depending on the value of \code{output}. The default value is \code{list}.
}
\examples{
\dontrun{
library("distdrawr")
specieslist <- data.frame(c("Bellis_perennis","Abies_alba",
                            "Capsella_bursa-pastoris"))
get.dist(specieslist, output = "list")
}
}
\references{
Datenbank FLORKART der Floristischen Kartierung Deutschlands,
Stand 2013, Bundesamt fuer Naturschutz (BfN) und Netzwerk Phytodiversitaet
Deutschland (NetPhyD): \url{http://www.floraweb.de}
}

