% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_names.R
\name{tsl_names_get}
\alias{tsl_names_get}
\title{Get Time Series Names from a Time Series Lists}
\usage{
tsl_names_get(tsl = NULL, zoo = TRUE)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}

\item{zoo}{(optional, logical) If TRUE, the attributes "name" of the zoo objects are returned. Default: TRUE}
}
\value{
list
}
\description{
A time series list has two sets of names: the names of the list items (as returned by \code{names(tsl)}), and the names of the contained zoo objects, as stored in their attribute "name". These names should ideally be the same, for the sake of data consistency. This function extracts either set of names,
}
\examples{
#initialize a time series list
tsl <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
)


#get names of zoo objects
tsl_names_get(
  tsl = tsl,
  zoo = TRUE
)

#get list names only
tsl_names_get(
  tsl = tsl,
  zoo = FALSE
  )

#same as
names(tsl)
}
\seealso{
Other tsl_management: 
\code{\link{tsl_burst}()},
\code{\link{tsl_colnames_clean}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_set}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_count_NA}()},
\code{\link{tsl_diagnose}()},
\code{\link{tsl_handle_NA}()},
\code{\link{tsl_join}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()},
\code{\link{tsl_to_df}()}
}
\concept{tsl_management}
