% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/momentum_to_wide.R
\name{momentum_to_wide}
\alias{momentum_to_wide}
\title{Momentum Data Frame to Wide Format}
\usage{
momentum_to_wide(df = NULL, sep = "__")
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=momentum]{momentum()}}, \code{\link[=momentum_ls]{momentum_ls()}}, or \code{\link[=momentum_dtw]{momentum_dtw()}}. Default: NULL}

\item{sep}{(required, character string) Separator between the name of the importance metric and the time series variable. Default: "__".}
}
\value{
data frame
}
\description{
Transforms a data frame returned by \code{\link[=momentum]{momentum()}} to wide format with the following columns:
\itemize{
\item \code{most_similar}: name of the variable with the highest contribution to similarity (most negative value in the \code{importance} column) for each pair of time series.
\item \code{most_dissimilar}: name of the variable with the highest contribution to dissimilarity (most positive value in the \code{importance} column) for each pair of time series.
\item \code{importance__variable_name}: contribution to similarity (negative values) or dissimilarity (positive values) of the given variable.
\item \code{psi_only_with__variable_name}: dissimilarity of the two time series when only using the given variable.
\item \code{psi_without__variable_name}: dissimilarity of the two time series when removing the given variable.
}
}
\examples{

tsl <- tsl_initialize(
  x = distantia::albatross,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global
  )

#importance data frame
df <- momentum(
  tsl = tsl
)

df

#to wide format
df_wide <- momentum_to_wide(
  df = df
)

df_wide

}
\seealso{
Other momentum_support: 
\code{\link{momentum_aggregate}()},
\code{\link{momentum_boxplot}()},
\code{\link{momentum_model_frame}()},
\code{\link{momentum_spatial}()},
\code{\link{momentum_stats}()}
}
\concept{momentum_support}
