% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{get_f1}
\alias{get_f1}
\title{Get the f1 dissimilarity factor}
\usage{
get_f1(data, ins, tcol, grouping)
}
\arguments{
\item{data}{A data frame with the dissolution profile data in wide format.}

\item{ins}{A vector of indices generated regarding the grouping.}

\item{tcol}{A vector of indices specifying the columns in \code{data} that
contain the \% release values. The length of \code{tcol} must be three or
longer.}

\item{grouping}{A character string specifying the column in \code{data} that
contains the group names (i.e. a factorial variable, e.g., for the
differentiation of batches or formulations of a drug product).}
}
\value{
The function returns the \eqn{f_1} value.
}
\description{
The function \code{get_f1()} calculates the dissimilarity factor \eqn{f_1}
for the assessment of dissolution profiles.
}
\details{
Similarity of dissolution profiles is often assessed using the
similarity factor \eqn{f_2}, as recommended by the EMA guideline (European
Medicines Agency 2010) \dQuote{On the investigation of bioequivalence}. The
evaluation of the similarity factor is based on the following constraints:
\enumerate{
  \item A minimum of three time points (zero excluded).
  \item The time points should be the same for the two formulations.
  \item Twelve individual values for every time point for each formulation.
  \item Not more than one mean value of > 85\% dissolved for any of the
    formulations.
  \item The relative standard deviation or coefficient of variation of any
    product should be less than 20\% for the first time point and less than
    10\% from the second to the last time point.
}

The \emph{dis}similarity factor, or difference factor, \eqn{f_1}, is the
counterpart of the similarity factor \eqn{f_2}. The difference factor
\eqn{f_1} is a measure of the relative error between two curves. Current FDA
guidelines suggest that two profiles can be considered similar if \eqn{f_1}
is less than \eqn{15} (\eqn{0 - 15}) and \eqn{f_2} is greater than \eqn{50}
(\eqn{50 - 100}), which is equivalent to an average difference of 10\% at
all sampling time points. The dissimilarity factor \eqn{f_1} is calculated
by aid of the equation

\deqn{f_1 = 100 \times \frac{\sum_{t=1}^{n} \left( \left| \bar{R}(t) -
  \bar{T}(t) \right| \right)}{\sum_{t=1}^{n} (\bar{R}(t))} .}{%
  f_1 = 100 (sum(abs(R.bar(t) - T.bar(t))) / sum(R.bar(t))) .}

In this equation
\describe{
  \item{\eqn{f_1}}{is the dissimilarity factor,}
  \item{\eqn{n}}{is the number of time points,}
  \item{\eqn{\bar{R}(t)}{R.bar(t)}}{is the mean percent reference drug
      dissolved at time \eqn{t} after initiation of the study, and}
  \item{\eqn{\bar{T}(t)}{T.bar(t)}}{is the mean percent test drug dissolved
      at time \eqn{t} after initiation of the study.}
}
}
\references{
United States Food and Drug Administration (FDA). Guidance for industry:
dissolution testing of immediate release solid oral dosage forms. 1997.\cr
\url{https://www.fda.gov/media/70936/download}

United States Food and Drug Administration (FDA). Guidance for industry:
immediate release solid oral dosage form: scale-up and post-approval
changes, chemistry, manufacturing and controls, \emph{in vitro} dissolution
testing, and \emph{in vivo} bioequivalence documentation (SUPAC-IR). 1995.\cr
\url{https://www.fda.gov/media/70949/download}

European Medicines Agency (EMA), Committee for Medicinal Products for
Human Use (CHMP). Guideline on the Investigation of Bioequivalence. 2010;
CPMP/EWP/QWP/1401/98 Rev. 1.\cr
\url{https://www.ema.europa.eu/en/documents/scientific-guideline/
guideline-investigation-bioequivalence-rev1_en.pdf}
}
\seealso{
\code{\link{get_f2}}.
}
\keyword{internal}
