% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.utilities.R
\name{make.dispRity}
\alias{make.dispRity}
\alias{fill.dispRity}
\title{Make and fill \code{dispRity}.}
\usage{
make.dispRity(data, tree, call, subsets)

fill.dispRity(data, tree)
}
\arguments{
\item{data}{A \code{matrix}.}

\item{tree}{Optional, a \code{phylo} or \code{multiPhylo} object.}

\item{call}{Optional, a \code{list} to be a \code{dispRity} call.}

\item{subsets}{Optional, a \code{list} to be a \code{dispRity} subsets list.}
}
\description{
Creating an empty \code{dispRity} object from a matrix
}
\examples{
## An empty dispRity object
make.dispRity()

## Still an empty dispRity object (with a matrix)
(empty <- make.dispRity(data = matrix(rnorm(12), ncol = 3)))

## A dispRity object with a matrix of 4*3
fill.dispRity(empty)

## A dispRity object with a tree
my_tree <- rtree(4, tip.label = c(1:4))
fill.dispRity(empty, tree = my_tree)

}
\author{
Thomas Guillerme
}
