% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/twoParamPlot.R
\name{twoParamPlot}
\alias{twoParamPlot}
\title{Used to plot the RAD and FoG results}
\usage{
twoParamPlot(projectName, type, RAD = "RAD20", FoG = "FoG20", RADmin = 30,
  tolMax = 100, width = 6, height = 4, xlabels = "line",
  xlabAngle = NA, order = NA, orderFactor = "line", overwrite = TRUE,
  savePDF = TRUE, popUp = TRUE, barplot = TRUE)
}
\arguments{
\item{projectName}{the short name to be used for the project}

\item{type}{specify whether the dataset to use is a dataframe with all data ("df") or an aggregated dataframe ("ag")}

\item{RAD}{specify the RAD (radius) parameter to be plotted ("RAD20", "RAD50" or "RAD80"), default = "RAD20".}

\item{FoG}{specify the FoG (fraction of growth) parameter to be plotted ("FoG20", "FoG50" or "FoG80"), default = "FoG20".}

\item{RADmin}{minimum distance from the disk for resistance plot (minimum y axis value), default = 30.}

\item{tolMax}{maximum y axis value for tolerance plot. Note tolerance is coverted to a percent, default = 100.}

\item{width}{a numeric value indicating the width of the pdf file generated}

\item{height}{a numeric value indicating the height of the pdf file generated}

\item{xlabels}{either a vector containing the desired x-axis labels, or a single value indicating the column name that contains the values to use (likely either the 'line' column or one of the type columns), default = "line".}

\item{xlabAngle}{indicates whether to print the x axis labels on a angle, if a number is provided this will be the angle used. The defauilt is not to plot on an angle, default = NA.}

\item{order}{can be either "factor" or "custom". If custom, supply a numberial vector the same length as the dataframe to indicate the desired order. If factor, supply the column name in \code{ordeFactor} to be used to factor.}

\item{orderFactor}{if \code{order = "factor"} supply the column name to be used to factor.}

\item{overwrite}{a logical value indicating whether to overwrite existing figures created on the same day for the same project name}

\item{savePDF}{a logical value indicating whether to save a PDF file or open a new quartz window. Defaults to TRUE (saves a pdf file).}

\item{popUp}{a logical value indicating whether to pop up the figure after it has been created}

\item{barplot}{whether to plot tolerance as a barplot (barplot = TRUE) or dotplot (barplot = FALSE), default = TRUE. Only possible when \code{type = "ag"}}
}
\value{
Either a pdf figure figure (projectName_RAD-FoG.pdf) saved to the 'figures' directory or a figure on screen
}
\description{
This function creates a pdf figure of plots showing the results of the imageJ analysis for resistance (RAD) and tolerance (FoG).
}
\details{
Basic parameter plotting functions to plot RAD and FoG parameter plots. Input can be the dataframe from either \code{\link{createDataframe}} \code{type="df"} or from \code{\link{aggregateData}} \code{type=="ag"}. The default is to plot RAD as a dotplot and tolerance as a barplot, though tolerance can also be plotted as a dotplot with \code{barplot=FALSE} (currently there is not support to plot RAD as a barplot in this framework).
}
\seealso{
\code{\link{oneParamPlot}} for a similar figure with one parameter or \code{\link{threeParamPlot}} for a similar figure with three parameters
}

