% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseq_directional.R
\docType{class}
\name{diseq_directional-class}
\alias{diseq_directional-class}
\title{Directional disequilibrium model with sample separation.}
\description{
The directional disequilibrium model consists of three equations and a separation
rule. The market is described by a linear demand, a linear supply equation and the short side
rule. The separation
rule splits the sample into regimes of excess supply and excess demand. If a price change is
positive at the time point of the observation, then the observation is classified as being in an
excess demand regime. Otherwise, it is assumed that it represents an excess supply state. The
model is estimated using full information maximum likelihood.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + u_{s,nt},}
\deqn{Q_{nt} = \min\{D_{nt},S_{nt}\},}
\deqn{\Delta P_{nt} \ge 0 \Longrightarrow D_{nt} \ge S_{nt}.}
}
\examples{
\donttest{
simulated_data <- simulate_model_data(
  "diseq_directional", 500, 3, # model type, observed entities, observed time points
  -0.2, 4.3, c(0.03, 0.02), c(0.03, 0.01), # demand coefficients
  0.0, 4.0, c(0.03), c(0.05, 0.02) # supply coefficients
)

# in the directional model prices cannot be included in both demand and supply
model <- new(
  "diseq_directional", # model type
  c("id", "date"), "date", "Q", "P", # keys, time point, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  correlated_shocks = TRUE # allow shocks to be correlated
)
}
}
