% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_linters.R
\name{diseasy_linters}
\alias{diseasy_linters}
\alias{nolint_position_linter}
\alias{nolint_line_length_linter}
\title{The custom linters of \code{diseasy}}
\usage{
nolint_position_linter(length = 80L)

nolint_line_length_linter(length = 80L)
}
\arguments{
\item{length}{maximum line length allowed. Default is 80L (Hollerith limit).}
}
\value{
A list of \code{lintr::Lint}
}
\description{
nolint_position_linter: Check that the \verb{nolint:} statements occur after the character limit

nolint_line_length_linter: Check that lines adhere to a given character limit, ignoring \code{nolint} statements
}
\examples{
## nolint_position_linter
# will produce lints
lintr::lint(
  text = paste0(strrep("x", 15L), "# nolint: object_name_linter"),
  linters = c(nolint_position_linter(length = 20L), lintr::object_name_linter())
)

# okay
lintr::lint(
  text = paste0(strrep("x", 20L), "# nolint: object_name_linter"),
  linters = c(nolint_position_linter(length = 20L), lintr::object_name_linter())
)

## nolint_line_length_linter
# will produce lints
lintr::lint(
  text = paste0(strrep("x", 25L), "# nolint: object_name_linter."),
  linters = c(nolint_line_length_linter(length = 20L), lintr::object_name_linter())
)

# okay
lintr::lint(
  text = paste0(strrep("x", 20L), "# nolint: object_name_linter."),
  linters = c(nolint_line_length_linter(length = 20L), lintr::object_name_linter())
)

}
\seealso{
\itemize{
\item \link[lintr:linters]{lintr::linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#long-lines}
}
}
