% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_kinsim.R
\name{kinsim}
\alias{kinsim}
\title{Simulate Biometrically informed Multivariate Data}
\usage{
kinsim(
  r_all = c(1, 0.5),
  npg_all = 500,
  npergroup_all = rep(npg_all, length(r_all)),
  mu_all = 0,
  variables = 2,
  mu_list = rep(mu_all, variables),
  reliability_list = NULL,
  r_vector = NULL,
  ace_all = c(1, 1, 1),
  ace_list = matrix(rep(ace_all, variables), byrow = TRUE, nrow = variables),
  cov_a = 0,
  cov_c = 0,
  cov_e = 0,
  ...
)
}
\arguments{
\item{r_all}{Levels of relatedness; default is MZ and DZ twins c(1,.5).}

\item{npg_all}{Sample size per group; default is 500.}

\item{npergroup_all}{Vector of sample sizes by group; default repeats \code{npg_all} for all groups}

\item{mu_all}{Mean for each generated variable; default is 0.}

\item{variables}{Number of variables to generate; default is 2. Currently, limited to max of two variables.}

\item{mu_list}{List of means by variable; default repeats \code{mu_all} for all variables}

\item{reliability_list}{Vector of Reliabilities for each generated variable; default is to repeat \code{reliability_all} for each variable}

\item{r_vector}{Alternative, give vector of r coefficients for entire sample.}

\item{ace_all}{Vector of variance components for each generated variable; default is c(1,1,1).}

\item{ace_list}{Matrix of ACE variance components by variable, where each row is its own variable; default is to repeat \code{ace_all} for each variable.}

\item{cov_a}{Shared variance for additive genetics (a); default is 0.}

\item{cov_c}{Shared variance for shared-environment (c); default is 0.}

\item{cov_e}{shared variance for non-shared-environment (e); default is 0.}

\item{...}{Optional pass on additional inputs.}
}
\value{
Returns \code{data.frame} with the following:
\item{Ai_1}{genetic component for variable i for kin1}
\item{Ai_2}{genetic component for variable i for kin2}
\item{Ci_1}{shared-environmental component for variable i for kin1}
\item{Ci_2}{shared-environmental component for variable i for kin2}
\item{Ei_1}{non-shared-environmental component for variable i for kin1}
\item{Ei_2}{non-shared-environmental component for variable i for kin2}
\item{yi_1}{generated variable i for kin1}
\item{yi_2}{generated variable i for kin2}
\item{r}{level of relatedness for the kin pair}
\item{id}{id}
}
\description{
Generate paired multivariate data, given ACE parameters.
}
