% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPolarized.r
\name{plotPolarized}
\alias{plotPolarized}
\title{Plots polarized genotypes}
\usage{
plotPolarized(
  genotypes,
  HI,
  cols = c("#FFFFFF", "#800080", "#FFE500", "#008080"),
  ...
)
}
\arguments{
\item{genotypes}{character matrix comprising of _012 encodings.}

\item{HI}{numeric vector of individual hybrid indices with length equal to number
of rows in \code{genotypes}.}

\item{cols}{vector of four colours, representing missing data, homozygots for
genotype 0, heterozygots and homozygots for genotype 2.}

\item{...}{additional arguments.}
}
\value{
No return value, called for side effects. In the default plot, purple and green
represent side of the barrier to geneflow encoded as \code{0} and \code{2}, respectively,
yellow shows heterozygots and white missing or undetermined genotypes. Individuals
are ordered according to the \code{HI}.
}
\description{
Plots genotypes that can be optionally polarized.
}
\details{
To import and polarize genotypes, use the function \code{\link{importPolarized}}.

When using \code{\link{diem}} with argument \code{verbose = TRUE}, hybrid indices,
\code{HI}, can be found in file 'HIwithOptimalPolarities.txt' in folder 'diagnostics'
in the working directory.
}
\examples{
gen <- importPolarized(
  file = system.file("extdata", "data7x10.txt", package = "diemr"),
  changePolarity = c(TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE),
  ChosenInds = 1:7
)

h <- c(0.625, 0.5, 0.455, 0.455, 0.227, 0.818, 0.292)

plotPolarized(genotypes = gen, HI = h)
}
