% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_values.R
\name{value_validate}
\alias{value_validate}
\alias{value_seq}
\alias{value_sample}
\alias{value_transform}
\alias{value_inverse}
\alias{value_set}
\title{Tools for working with parameter values}
\usage{
value_validate(object, values, ..., call = caller_env())

value_seq(object, n, original = TRUE)

value_sample(object, n, original = TRUE)

value_transform(object, values)

value_inverse(object, values)

value_set(object, values)
}
\arguments{
\item{object}{An object with class \code{quant_param}.}

\item{values}{A numeric vector or list (including \code{Inf}). Values
\emph{cannot} include \code{unknown()}. For \code{value_validate()}, the units should be
consistent with the parameter object's definition.}

\item{...}{These dots are for future extensions and must be empty.}

\item{call}{The call passed on to \code{\link[cli:cli_abort]{cli::cli_abort()}}.}

\item{n}{An integer for the (maximum) number of values to return. In some
cases where a sequence is requested, the result might have less than \code{n}
values. See Details.}

\item{original}{A single logical. Should the range values be in the natural
units (\code{TRUE}) or in the transformed space (\code{FALSE}, if applicable)?}
}
\value{
\code{value_validate()} throws an error or silently returns \code{values} if they are
contained in the values of the \code{object}.

\code{value_transform()} and \code{value_inverse()} return a \emph{vector} of
numeric values.

\code{value_seq()} and \code{value_sample()} return a vector of values consistent
with the \code{type} field of \code{object}.
}
\description{
Setters and validators for parameter values. Additionally, tools for creating
sequences of parameter values and for transforming parameter values
are provided.
}
\details{
For sequences of integers, the code uses
\code{unique(floor(seq(min, max, length.out = n)))} and this may generate an
uneven set of values shorter than \code{n}. This also means that if \code{n} is larger
than the range of the integers, a smaller set will be generated. For
qualitative parameters, the first \code{n} values are returned.

For quantitative parameters, any \code{values} contained in the object
are sampled with replacement. Otherwise, a sequence of values
between the \code{range} values is returned. It is possible that less
than \code{n} values are returned.

For qualitative parameters, sampling of the \code{values} is conducted
with replacement. For qualitative values, a random uniform distribution
is used.
}
\examples{
library(dplyr)

penalty() \%>\% value_set(-4:-1)

# Is a specific value valid?
penalty()
penalty() \%>\% range_get()
value_validate(penalty(), 17)

# get a sequence of values
cost_complexity()
cost_complexity() \%>\% value_seq(4)
cost_complexity() \%>\% value_seq(4, original = FALSE)

on_log_scale <- cost_complexity() \%>\% value_seq(4, original = FALSE)
nat_units <- value_inverse(cost_complexity(), on_log_scale)
nat_units
value_transform(cost_complexity(), nat_units)

# random values in the range
set.seed(3666)
cost_complexity() \%>\% value_sample(2)

}
