% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_svm.R
\name{cost}
\alias{cost}
\alias{margin}
\title{Support vector machine parameters}
\usage{
cost(range = c(-10, -1), trans = log2_trans())

margin(range = c(0, 0.2), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Parameters related to the SVM objective function(s).
}
\details{
These are used by \code{parsnip::svm_rbf()} and \code{parsnip::svm_poly()}
}
\examples{
cost()
margin()
}
