% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_collocations.R
\name{get_collocations}
\alias{get_collocations}
\title{Get collocations for word in corpus}
\usage{
get_collocations(pids, word, before = 10, after = 10, sample_size = 5000)
}
\arguments{
\item{pids}{A vector or data frame containing the unique identifiers of the texts in the corpus.}

\item{word}{The target word for which you want to find concordances.}

\item{before}{The number of words before the target word to include in the context (default is 10).}

\item{after}{The number of words after the target word to include in the context (default is 10).}

\item{sample_size}{The number of samples to retrieve from the API (default is 5000).}
}
\value{
A data frame of concordances.
}
\description{
This function retrieves collocation data from a corpus using a given word and a list of unique identifiers (pids) of corpus data frame.
}
\examples{
pids <- c("URN:NBN:no-nb_digibok_2008051404065", "URN:NBN:no-nb_digibok_2010092120011")
word <- "."
collocations <- get_collocations(pids, word)

}
