% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{set_imp}
\alias{set_imp}
\title{Reset number of imputations for a DGP emulator}
\usage{
set_imp(object, B = 10)
}
\arguments{
\item{object}{an instance of the S3 class \code{dgp}.}

\item{B}{the number of imputations to produce predictions from \code{object}. Increase the value to account for
more imputation uncertainties with slower predictions. Decrease the value for lower imputation uncertainties
but faster predictions. Defaults to \code{10}.}
}
\value{
An updated \code{object} with the information of \code{B} incorporated.
}
\description{
This function resets the number of imputations for predictions from a DGP emulator.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
\itemize{
\item This function is useful when a DGP emulator has been trained and one wants to make faster predictions by decreasing
the number of imputations without rebuilding the emulator.
\item The following slots:
\itemize{
\item \code{loo} and \code{oos} created by \code{\link[=validate]{validate()}}; and
\item \code{results} created by \code{\link[=predict]{predict()}}
in \code{object} will be removed and not contained in the returned object.
}
}
}
\examples{
\dontrun{

# See design() for an example.
}
}
