% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wangengel_98}
\alias{wangengel_98}
\title{Wang and Engel equation of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation as a formula object.}
  \item{eqAlt}{The equation as a string.}
  \item{name}{The equation name.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameter values found in the literature with their references.}
  \item{com}{An otional comment about the equation use.}
  \item{id}{An id to identificate the equation.}
}}
\source{
\url{http://dx.doi.org/10.1016/S0308-521X(98)00028-6}
}
\usage{
wangengel_98
}
\description{
Wang, E., and Engel, T. (1998) Simulation of phenological development of wheat crops.
Agricultural systems 58(1): 1-24.
}
\details{
Equation:
\deqn{rT = \frac{2 * (T - Tmin)^{aa} * (Topt - Tmin)^{aa} - (T - Tmin)^{2 * aa}}{(Topt - Tmin)^{2 * aa}}}{%
      rT = (2 * (T - Tmin)^aa * (Topt - Tmin)^aa - (T - Tmin)^(2 * aa)) / ((Topt - Tmin)^(2 * aa))}

where rT is the development rate, T the temperature, Tmin the minimum temperature,
Topt the optimum temperature, and aa a constant.
}
\keyword{datasets}
