% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_tif}
\alias{read_tif}
\title{Read tiff image as array object.}
\usage{
read_tif(path, n_ch = 1)
}
\arguments{
\item{path}{The path to the image file on disk.}

\item{n_ch}{The number of channels in the image.}
}
\value{
An array of integers representing the image.
}
\description{
Read in a tiff image file from the disk as an array of pixel intensities.
}
\details{
This function wraps \code{\link[tiff:readTIFF]{tiff::readTIFF()}}.

Thinking of the read image as a matrix \code{mat}, the pixel at \eqn{x = }\code{i},
\eqn{y = }\code{j} has colour based on the value of \code{mat[j, i]} where the
\eqn{x} axis points right and the \eqn{y} axis points down. However, when one
prints a matrix in a console (or views it in a program such as excel), the
value in position \eqn{x = }\code{i}, \eqn{y = }\code{j} is from \code{mat[j, i]}, so if
you're confused about a phantom transposition, this is why.

If the result has
}
\examples{
img <- read_tif(system.file('extdata', 'bleached.tif', package = 'detrendr'),
                n_ch = 1)
display(img[, , 1])

}
