% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_functions.R
\name{ma_decomp}
\alias{ma_decomp}
\title{Decomposition of Time Series Using Moving Averages}
\usage{
ma_decomp(yt, k_trend = 4, k_season = 5, season = NULL)
}
\arguments{
\item{yt}{a time series object of class \code{"ts"} or an object that can be 
transformed to that class using \code{\link[stats]{as.ts}}.}

\item{k_trend}{the complete absolute bandwidth (in years); represents the data 
of how many years to use around the estimation time point to consider 
for trend smoothing.}

\item{k_season}{the complete absolute bandwidth (in years); represents the data 
of how many years (only from the same quarter, month, etc.) to use around the 
estimation time point for trend + seasonality 
smoothing.}

\item{season}{the seasonal period in \code{yt}; by default, the seasonal 
period is obtained automatically from \code{yt}.}
}
\value{
An S4 object with the following elements is returned.
\describe{
\item{decomp}{an object of class \code{"mts"} that consists of the
decomposed time series data.}
\item{ts_name}{the object name of the initially provided time series object.}
\item{frequency}{the frequency of the time series.}
\item{k_trend}{the same as the input argument \code{k_trend}.}
\item{k_season}{the same as the input argument \code{k_season}.}
}
}
\description{
Trend and seasonality are modelled in a two-step approach, where first the 
trend is being estimated using moving averages and then trend + seasonality 
are being estimated using moving averages. The difference is then the 
estimated seasonality.
}
\details{
Apply moving averages to estimate trend and seasonality 
in a given time series. This approach results in missings \code{NA} at 
boundary points.
}
\examples{
est <- ma_decomp(log(EXPENDITURES), k_trend = 6, k_season = 7)
est

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
