% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.ulsif}
\alias{print.ulsif}
\title{Print a \code{ulsif} object}
\usage{
\method{print}{ulsif}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{Object of class \code{ulsif}.}

\item{digits}{Number of digits to use when printing the output.}

\item{...}{further arguments on how to format the number of digits.}
}
\value{
\code{invisble} The inputted \code{ulsif} object.
}
\description{
Print a \code{ulsif} object
}
\examples{
set.seed(123)
# Fit model
dr <- ulsif(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
ulsif(numerator_small, denominator_small, sigma = 2, lambda = 2)
}
\seealso{
\code{\link{print}}, \code{\link{ulsif}}
}
