\name{plot.errorfdm}
\alias{plot.errorfdm}
\title{Plot differences between actuals and estimates from fitted demographic model}
\usage{\method{plot}{errorfdm}(x, transform = TRUE, ...)
}

\arguments{
\item{x}{Object of class \code{"errorfdm"} generated by \code{\link{compare.demogdata}}.}
\item{transform}{Plot errors on transformed scale or original scale?}
\item{...}{Plotting parameters}
}

\description{Function produces a plot of errors from a fitted demographic model.}

\value{None.}

\seealso{\link{compare.demogdata}}

\author{Rob J Hyndman}
\examples{
fr.fit <- lca(extract.years(fr.mort,years=1921:1980))
fr.error <- compare.demogdata(fr.mort, forecast(fr.fit,20))
plot(fr.error)
}
\keyword{hplot}
