/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.flow;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import org.jgrapht.Graph;
import org.jgrapht.alg.flow.MaximumFlowAlgorithmBase;
import org.jgrapht.alg.interfaces.MaximumFlowAlgorithm;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.alg.util.extension.ExtensionFactory;

public class PushRelabelMFImpl<V, E>
extends MaximumFlowAlgorithmBase<V, E> {
    private static final boolean DIAGNOSTIC_ENABLED = false;
    private final ExtensionFactory<VertexExtension> vertexExtensionsFactory = () -> new VertexExtension();
    private final ExtensionFactory<MaximumFlowAlgorithmBase.AnnotatedFlowEdge> edgeExtensionsFactory = () -> new MaximumFlowAlgorithmBase.AnnotatedFlowEdge(this);
    private Map<Integer, Integer> labeling;
    boolean flowBack;
    private PushRelabelDiagnostic diagnostic;

    public PushRelabelMFImpl(Graph<V, E> network) {
        this(network, 1.0E-9);
    }

    public PushRelabelMFImpl(Graph<V, E> network, double epsilon) {
        super(network, epsilon);
    }

    void init(V source, V sink) {
        super.init(source, sink, this.vertexExtensionsFactory, this.edgeExtensionsFactory);
        this.labeling = new HashMap<Integer, Integer>();
        this.flowBack = false;
    }

    public void initialize(VertexExtension source, VertexExtension sink, Queue<VertexExtension> active) {
        source.label = this.network.vertexSet().size();
        source.excess = Double.POSITIVE_INFINITY;
        this.label(source, sink);
        for (MaximumFlowAlgorithmBase.AnnotatedFlowEdge ex : source.getOutgoing()) {
            this.pushFlowThrough(ex, ex.capacity);
            if (((MaximumFlowAlgorithmBase.VertexExtensionBase)ex.getTarget()).prototype == sink.prototype) continue;
            active.offer((VertexExtension)ex.getTarget());
        }
    }

    private void label(VertexExtension source, VertexExtension sink) {
        HashSet<VertexExtension> seen = new HashSet<VertexExtension>();
        ArrayDeque<VertexExtension> q = new ArrayDeque<VertexExtension>();
        q.offer(sink);
        sink.label = 0;
        seen.add(sink);
        seen.add(source);
        while (!q.isEmpty()) {
            VertexExtension ux = (VertexExtension)q.poll();
            for (MaximumFlowAlgorithmBase.AnnotatedFlowEdge ex : ux.getOutgoing()) {
                VertexExtension vx = (VertexExtension)ex.getTarget();
                if (seen.contains(vx)) continue;
                seen.add(vx);
                vx.label = ux.label + 1;
                q.add(vx);
            }
        }
        for (Object v : this.network.vertexSet()) {
            VertexExtension vx = this.getVertexExtension(v);
            if (!this.labeling.containsKey(vx.label)) {
                this.labeling.put(vx.label, 1);
                continue;
            }
            this.labeling.put(vx.label, this.labeling.get(vx.label) + 1);
        }
    }

    @Override
    public MaximumFlowAlgorithm.MaximumFlow<E> getMaximumFlow(V source, V sink) {
        this.calculateMaximumFlow(source, sink);
        this.maxFlow = this.composeFlow();
        return new MaximumFlowAlgorithm.MaximumFlowImpl(this.maxFlowValue, this.maxFlow);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double calculateMaximumFlow(V source, V sink) {
        this.init(source, sink);
        active = new ArrayDeque<VertexExtension>();
        this.initialize(this.getVertexExtension(source), this.getVertexExtension(sink), active);
        block0: while (!active.isEmpty()) {
            ux = (VertexExtension)active.poll();
            while (true) {
                for (MaximumFlowAlgorithmBase.AnnotatedFlowEdge ex : ux.getOutgoing()) {
                    if (!this.isAdmissible(ex)) continue;
                    if (ex.getTarget().prototype != sink && ex.getTarget().prototype != source) {
                        active.offer((VertexExtension)ex.getTarget());
                    }
                    if (!this.discharge(ex)) continue;
                    break;
                }
                if (!VertexExtension.access$100(ux)) continue block0;
                this.relabel(ux);
                if (this.flowBack || this.labeling.containsKey(0) || this.labeling.containsKey(1)) ** continue;
                VertexExtension.access$002(this.getVertexExtension(source), Collections.max(this.labeling.keySet()) + 1);
                this.flowBack = true;
            }
        }
        for (E e : this.network.edgesOf(sink)) {
            edge = (MaximumFlowAlgorithmBase.AnnotatedFlowEdge)this.edgeExtensionManager.getExtension(e);
            this.maxFlowValue += this.directed_graph != false ? edge.flow : edge.flow + edge.getInverse().flow;
        }
        return this.maxFlowValue;
    }

    private void relabel(VertexExtension vx) {
        assert (vx.hasExcess());
        int min = Integer.MAX_VALUE;
        for (MaximumFlowAlgorithmBase.AnnotatedFlowEdge ex : vx.getOutgoing()) {
            VertexExtension ux;
            if (!ex.hasCapacity() || min <= (ux = (VertexExtension)ex.getTarget()).label) continue;
            min = ux.label;
        }
        assert (this.labeling.get(vx.label) > 0);
        this.updateLabeling(vx, min + 1);
        if (min != Integer.MAX_VALUE) {
            vx.label = min + 1;
        }
    }

    private void updateLabeling(VertexExtension vx, int l) {
        if (this.labeling.get(vx.label) == 1) {
            this.labeling.remove(vx.label);
        } else {
            this.labeling.put(vx.label, this.labeling.get(vx.label) - 1);
        }
        if (!this.labeling.containsKey(l)) {
            this.labeling.put(l, 1);
        } else {
            this.labeling.put(l, this.labeling.get(l) + 1);
        }
    }

    private boolean discharge(MaximumFlowAlgorithmBase.AnnotatedFlowEdge ex) {
        VertexExtension ux = (VertexExtension)ex.getSource();
        this.pushFlowThrough(ex, Math.min(ux.excess, ex.capacity - ex.flow));
        return !ux.hasExcess();
    }

    @Override
    protected void pushFlowThrough(MaximumFlowAlgorithmBase.AnnotatedFlowEdge ex, double f) {
        ((MaximumFlowAlgorithmBase.VertexExtensionBase)ex.getSource()).excess -= f;
        ((MaximumFlowAlgorithmBase.VertexExtensionBase)ex.getTarget()).excess += f;
        assert (((MaximumFlowAlgorithmBase.VertexExtensionBase)ex.getSource()).excess >= 0.0 && ((MaximumFlowAlgorithmBase.VertexExtensionBase)ex.getTarget()).excess >= 0.0);
        super.pushFlowThrough(ex, f);
    }

    private boolean isAdmissible(MaximumFlowAlgorithmBase.AnnotatedFlowEdge e) {
        return e.hasCapacity() && ((VertexExtension)e.getSource()).label == ((VertexExtension)e.getTarget()).label + 1;
    }

    private VertexExtension getVertexExtension(V v) {
        return (VertexExtension)this.vertexExtensionManager.getExtension(v);
    }

    public class VertexExtension
    extends MaximumFlowAlgorithmBase.VertexExtensionBase {
        private int label;

        public VertexExtension() {
            super(PushRelabelMFImpl.this);
        }

        private boolean hasExcess() {
            return this.excess > 0.0;
        }

        public String toString() {
            return this.prototype.toString() + String.format(" { LBL: %d } ", this.label);
        }
    }

    private class PushRelabelDiagnostic {
        Map<Pair<V, V>, Integer> discharges = new HashMap();
        long dischargesCounter = 0L;
        Map<Pair<Integer, Integer>, Integer> relabels = new HashMap<Pair<Integer, Integer>, Integer>();
        long relabelsCounter = 0L;

        private PushRelabelDiagnostic() {
        }

        private void incrementDischarges(MaximumFlowAlgorithmBase.AnnotatedFlowEdge ex) {
            Pair p = Pair.of(((MaximumFlowAlgorithmBase.VertexExtensionBase)ex.getSource()).prototype, ((MaximumFlowAlgorithmBase.VertexExtensionBase)ex.getTarget()).prototype);
            if (!this.discharges.containsKey(p)) {
                this.discharges.put(p, 0);
            }
            this.discharges.put(p, this.discharges.get(p) + 1);
            ++this.dischargesCounter;
        }

        private void incrementRelabels(int from, int to) {
            Pair<Integer, Integer> p = Pair.of(from, to);
            if (!this.relabels.containsKey(p)) {
                this.relabels.put(p, 0);
            }
            this.relabels.put(p, this.relabels.get(p) + 1);
            ++this.relabelsCounter;
        }

        void dump() {
            HashMap<Integer, Integer> labels = new HashMap<Integer, Integer>();
            for (Object v : PushRelabelMFImpl.this.network.vertexSet()) {
                VertexExtension vx = PushRelabelMFImpl.this.getVertexExtension(v);
                if (!labels.containsKey(vx.label)) {
                    labels.put(vx.label, 0);
                }
                labels.put(vx.label, (Integer)labels.get(vx.label) + 1);
            }
            System.out.println("LABELS  ");
            System.out.println("------  ");
            System.out.println(labels);
            ArrayList<Map.Entry<Pair<Integer, Integer>, Integer>> relabelsSorted = new ArrayList<Map.Entry<Pair<Integer, Integer>, Integer>>(this.relabels.entrySet());
            Collections.sort(relabelsSorted, (o1, o2) -> -((Integer)o1.getValue() - (Integer)o2.getValue()));
            System.out.println("RELABELS    ");
            System.out.println("--------    ");
            System.out.println("    Count:  " + this.relabelsCounter);
            System.out.println("            " + relabelsSorted);
            ArrayList dischargesSorted = new ArrayList(this.discharges.entrySet());
            Collections.sort(dischargesSorted, (one, other) -> -((Integer)one.getValue() - (Integer)other.getValue()));
            System.out.println("DISCHARGES  ");
            System.out.println("----------  ");
            System.out.println("    Count:  " + this.dischargesCounter);
            System.out.println("            " + dischargesSorted);
        }
    }
}

