% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_additive.R
\name{model_additive}
\alias{model_additive}
\title{Additive DEA model.}
\usage{
model_additive(datadea,
               dmu_eval = NULL,
               dmu_ref = NULL,
               orientation = NULL,
               weight_slack_i = 1,
               weight_slack_o = 1,
               rts = c("crs", "vrs", "nirs", "ndrs", "grs"),
               L = 1,
               U = 1,
               compute_target = TRUE,
               returnlp = FALSE,
               ...)
}
\arguments{
\item{datadea}{The data, including \code{n} DMUs, \code{m} inputs and \code{s} outputs.}

\item{dmu_eval}{A numeric vector containing which DMUs have to be evaluated.
If \code{NULL} (default), all DMUs are considered.}

\item{dmu_ref}{A numeric vector containing which DMUs are the evaluation reference set.
If \code{NULL} (default), all DMUs are considered.}

\item{orientation}{This parameter is either \code{NULL} (default) or a string, equal to
"io" (input-oriented) or "oo" (output-oriented). It is used to modify the weight slacks. 
If input-oriented, \code{weight_slack_o} are taken 0.
If output-oriented, \code{weight_slack_i} are taken 0.}

\item{weight_slack_i}{A value, vector of length \code{m}, or matrix \code{m} x
\code{ne} (where \code{ne} is the length of \code{dmu_eval})
with the weights of the input slacks. If 0, output-oriented.}

\item{weight_slack_o}{A value, vector of length \code{s}, or matrix \code{s} x
\code{ne} (where \code{ne} is the length of \code{dmu_eval})
with the weights of the output slacks. If 0, input-oriented.}

\item{rts}{A string, determining the type of returns to scale, equal to "crs" (constant),
"vrs" (variable), "nirs" (non-increasing), "ndrs" (non-decreasing) or "grs" (generalized).}

\item{L}{Lower bound for the generalized returns to scale (grs).}

\item{U}{Upper bound for the generalized returns to scale (grs).}

\item{compute_target}{Logical. If it is \code{TRUE}, it computes targets.}

\item{returnlp}{Logical. If it is \code{TRUE}, it returns the linear problems
(objective function and constraints).}

\item{...}{Ignored, for compatibility issues.}
}
\description{
Solve the additive model of Charnes et. al (1985). With the current
version of deaR, it is possible to solve input-oriented, output-oriented,
and non-oriented additive dea model under constant and non-constant returns-to-scale.

Besides, the user can set weights for the input slacks and/or output slacks. So,
it is also possible to solve weighted additive models. For example: Measure of
Inefficiency Proportions (MIP), Range Adjusted Measure (RAM), etc.
}
\note{
In this model, the efficiency score is the sum of the slacks. Therefore,
a DMU is efficient when the objective value (\code{objval}) is zero.
}
\examples{
# Example 1. 
# Replication of results in Charnes et. al (1994, p. 27)
x <- c(2, 3, 6, 9, 5, 4, 10) 
y <- c(2, 5, 7, 8, 3, 1, 7)
data_example <- data.frame(dmus = letters[1:7], x, y)
data_example <- read_data(data_example, 
                          ni = 1, 
                          no = 1)
result <- model_additive(data_example, 
                         rts = "vrs")
efficiencies(result)
slacks(result)
lambdas(result)

# Example 2.
# Measure of Inefficiency Proportions (MIP).
x <- c(2, 3, 6, 9, 5, 4, 10) 
y <- c(2, 5, 7, 8, 3, 1, 7)
data_example <- data.frame(dmus = letters[1:7], x, y)
data_example <- read_data(data_example, ni = 1, no = 1)
result2 <- model_additive(data_example, rts = "vrs",
                          weight_slack_i = 1 / data_example[["input"]],
                          weight_slack_o = 1 / data_example[["output"]])
slacks(result2)

# Example 3.
# Range Adjusted Measure of Inefficiencies (RAM).
x <- c(2, 3, 6, 9, 5, 4, 10) 
y <- c(2, 5, 7, 8, 3, 1, 7)
data_example <- data.frame(dmus = letters[1:7], x, y)
data_example <- read_data(data_example, ni = 1, no = 1)
range_i <- apply(data_example[["input"]], 1, max) -
           apply(data_example[["input"]], 1, min)
range_o <- apply(data_example[["output"]], 1, max) -
           apply(data_example[["output"]], 1, min)
w_range_i <- 1 / (range_i * (dim(data_example[["input"]])[1] +
                             dim(data_example[["output"]])[1]))
w_range_o <- 1 / (range_o * (dim(data_example[["input"]])[1] +
                             dim(data_example[["output"]])[1]))
result3 <- model_additive(data_example,
                          rts = "vrs",
                          weight_slack_i = w_range_i,
                          weight_slack_o = w_range_o)
slacks(result3)

}
\references{
Charnes, A.; Cooper, W.W.; Golany, B.; Seiford, L.; Stuz, J. (1985) "Foundations
of Data Envelopment Analysis for Pareto-Koopmans Efficient Empirical Production
Functions", Journal of Econometrics, 30(1-2), 91-107.
\doi{10.1016/0304-4076(85)90133-2}
  
Charnes, A.; Cooper, W.W.; Lewin, A.Y.; Seiford, L.M. (1994). Data Envelopment
Analysis: Theory, Methology, and Application. Boston: Kluwer Academic Publishers.
\doi{10.1007/978-94-011-0637-5}

Cooper, W.W.; Park, K.S.; Pastor, J.T. (1999). "RAM: A Range Adjusted Measure
of Inefficiencies for Use with Additive Models, and Relations to Other Models
and Measures in DEA". Journal of Productivity Analysis, 11, p. 5-42.
\doi{10.1023/A:1007701304281}
}
\seealso{
\code{\link{model_addsupereff}}
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
