% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dea.R
\name{plot.dea}
\alias{plot.dea}
\title{Plot for DEA models.}
\usage{
\method{plot}{dea}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"dea"} obtained by a dea model function.}

\item{...}{Ignored, for compatibility issues.}
}
\value{
Depending on the model it returns a single data.frame containing: efficiencies, 
slacks, lambdas, targets, references or a list of data.frames with the cross-efficiencies computed 
with different methods (Arbitrary, Method II or Method III (see CITA)) or, in case the model is a
 malmquist index, a single data.frame with the coefficients for the different periods.
}
\description{
Plot some attribute of a DEA model (conventional, fuzzy or Malmquist).
}
\examples{
data_example <- read_data(datadea = Fortune500,
                          dmus = 1,
                          inputs = 2:4, 
                          outputs = 5:6)
result <- model_basic(data_example)
plot(result)

}
\references{
#' Zhu, J. (2014). Quantitative Models for Performance Evaluation and Benchmarking. Data Envelopment Analysis with Spreadsheets. 3rd Edition Springer, New York. DOI: 10.1007/978-3-319-06647-9
}
\author{
\strong{Vicente Coll-Serrano} (\email{vicente.coll@uv.es}).
\emph{Quantitative Methods for Measuring Culture (MC2). Applied Economics.}

\strong{Vicente Bolós} (\email{vicente.bolos@uv.es}).
\emph{Department of Business Mathematics}

\strong{Rafael Benítez} (\email{rafael.suarez@uv.es}).
\emph{Department of Business Mathematics}

University of Valencia (Spain)
}
