% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikehoods.R
\name{logllk_lcm}
\alias{logllk_lcm}
\title{Calculate loglikelihood of the latent class model, conditional on tree structure}
\usage{
logllk_lcm(
  response_matrix,
  leaf_data,
  prior_class_probability,
  prior_dirichlet,
  ClassItem,
  Class_count
)
}
\arguments{
\item{response_matrix}{a N by J binary matrix, where the i,j-th element is the response
of item j for individual i}

\item{leaf_data}{a K by J matrix of logit(theta_{kj})}

\item{prior_class_probability}{a length K vector, where the k-th element is the
probability of assigning an individual to class k. It does not have to sum up to 1}

\item{prior_dirichlet}{a vector of length K. The Dirichlet prior of class probabilities}

\item{ClassItem}{a K by J matrix, where the k,j-th element counts the number of individuals
that belong to class k have a positive response to item j}

\item{Class_count}{a length K vector, where the k-th element counts the number of individuals
belonging to class k}
}
\value{
a numeric of loglikelihood
}
\description{
Calculate loglikelihood of the latent class model, conditional on tree structure
}
\seealso{
Other likelihood functions: 
\code{\link{logllk_ddt_lcm}()},
\code{\link{logllk_ddt}()},
\code{\link{logllk_div_time_one}()},
\code{\link{logllk_div_time_two}()},
\code{\link{logllk_location}()},
\code{\link{logllk_tree_topology}()}
}
\concept{likelihood functions}
