% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-extend.R
\name{define_clusters}
\alias{define_clusters}
\title{Define droplet clusters}
\usage{
define_clusters(plate)
}
\arguments{
\item{plate}{A ddPCR plate}
}
\value{
A list of potential droplet clusters for the plate type.
}
\description{
Every ddPCR plate type has a set of potential clusters the droplets can be
assigned to. When creating a custom plate type, if your plate type uses a
different set of clusters than its parent type, you must define this function
to return the cluster names. When defining this function, you can use 
\code{NextMethod("define_clusters")} to get a list of the clusters available
in the parent type if you want to simply add new clusters without defining
all of them.
}
\seealso{
\code{\link[ddpcr]{clusters}}

\code{\link[ddpcr]{clusters}}\cr
\code{\link[ddpcr]{parent_plate_type}}\cr
\code{\link[ddpcr]{define_params}}\cr
\code{\link[ddpcr]{define_steps}}
}
\keyword{internal}

