% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empty.R
\name{remove_empty}
\alias{remove_empty}
\title{Analysis step: Remove empty droplets}
\usage{
remove_empty(plate)
}
\arguments{
\item{plate}{A ddPCR plate.}
}
\value{
A ddPCR plate with the empty droplets marked as empty. The plate's
metadata will have a few new variables relating to the empty droplets.
}
\description{
Find the empty droplets (double-negative droplets) in each well in a plate
and assign these droplets to the \emph{EMPTY} cluster. \cr\cr
\href{https://github.com/daattali/ddpcr#advanced-topic-2-algorithms-used-in-each-step}{See the README} for
more information about the algorithm used to find empty droplets.
}
\details{
This function is recommended to be run as part of an analysis pipeline (ie.
within the \code{\link[ddpcr]{analyze}} function) rather than being called
directly.
}
\note{
This is an S3 generic, which means that different ddPCR plate types can
implement this function differently.
\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for
more information on how to implement custom ddPCR plate types.
}
\seealso{
\code{\link[ddpcr]{analyze}}\cr
\code{\link[ddpcr]{get_empty_cutoff}}
}
\keyword{internal}

