% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dca}
\alias{plot.dca}
\title{Plot DCA Object with ggplot}
\usage{
\method{plot}{dca}(
  x,
  type = NULL,
  smooth = FALSE,
  span = 0.2,
  style = c("color", "bw"),
  show_ggplot_code = FALSE,
  ...
)
}
\arguments{
\item{x}{dca object created with \code{dca()}}

\item{type}{indicates type of plot to produce. Must be one of
\code{c("net_benefit", "net_intervention_avoided", "standardized_net_benefit")}.
The default is
\code{"net_benefit"}, unless the net intervention has been calculated
when \code{"net_intervention_avoided"} is used, or if \code{"standardized_net_benefit"}
has been calculated.}

\item{smooth}{Logical indicator whether plot will be smooth with
\code{ggplot2::stat_smooth()}. Default is \code{FALSE}}

\item{span}{when \code{smooth = TRUE}, Controls the amount of smoothing for
loess smoother. Smaller numbers produce wigglier lines, larger numbers
produce smoother lines. Default is \code{0.2}.}

\item{style}{Must be one of \code{c("color", "bw")}. Default is \code{"color"}, and
\code{"bw"} will print a black and white figure}

\item{show_ggplot_code}{Logical indicating whether to print ggplot2 code used to
create figure. Default is \code{FALSE}. Set to \code{TRUE} to perform advanced figure
customization}

\item{...}{not used}
}
\value{
a ggplot2 object
}
\description{
Plot DCA Object with ggplot
}
\examples{
dca(cancer ~ cancerpredmarker, data = df_binary) \%>\%
  plot(smooth = TRUE, show_ggplot_code = TRUE)
}
\seealso{
\code{\link[=dca]{dca()}}, \code{\link[=net_intervention_avoided]{net_intervention_avoided()}}, \code{\link[=standardized_net_benefit]{standardized_net_benefit()}}, \code{\link[=as_tibble.dca]{as_tibble.dca()}}
}
\author{
Daniel D Sjoberg
}
