% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/template_matching.R
\docType{methods}
\name{fastTemplateMatching}
\alias{fastTemplateMatching}
\alias{fastTemplateMatching,array-method}
\title{Fast Template Matching via Cross-Correlation}
\usage{
fastTemplateMatching(input, ...)

\S4method{fastTemplateMatching}{array}(input, ...)
}
\arguments{
\item{input}{is a four-dimensional array of signal intensities.}

\item{...}{Additional variables passed to the \code{plot} function.}
}
\value{
A list of objects are returned: \item{out}{Motion-corrected version
of the four-dimensional array.} \item{offset}{Translations (in 3D) for each
volume in the 4D array.} \item{t.center}{Estimated center of the binary
mask.}
}
\description{
Motion correction and/or co-registration of three-dimensional arrays
(medical imaging data) are performed by applying a user-defined mask of
voxels.  Normalized cross-correlations (in 3D) are computed using the FFT.
}
\details{
An extremely basic method of motion correction/co-registration is
implemented by estimating \dQuote{local} cross-correlations based on a
binary mask that is a subset of the original three-dimensional volume.  All
convolutions are preformed via the FFT (\code{\link{fft}}) and repetitive
calculations are minimized where possible.

Only whole-voxel translations are considered.  This does not begin to
capture the true effects of motion in soft tissue, but we assume that the
object of interest (e.g., tumor) is a fairly rigid structure.  Potential
extensions include rigid-body, affine and nonlinear registration techniques
along with interploation schemes in order to capture intra-voxel
manipulations of the data.
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\references{
Lewis, J.P. (2003) Fast normalized cross-correlation.\cr
\url{www.idiom.com/~zilla/}
}
\seealso{
\code{\link{convFFT}}, \code{\link{findCenter}},
\code{\link{shift3D}}
}

