% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{check_condition}
\alias{check_condition}
\title{Create a condition of the given type}
\usage{
check_condition(msg, behavior, data, type)
}
\arguments{
\item{msg}{Message to report}

\item{behavior}{Statement of the correct behavior (i.e. what the higher level
function was checking for)}

\item{data}{Data to return (e.g. invalid values that need attention)}

\item{type}{One of "check_pass", "check_warn", "check_fail"}
}
\value{
An S3 object of class "check_pass", "check_warn", or "check_fail"
}
\description{
Create a condition of the given type
}
\examples{
strict <- TRUE
check_condition(
  msg = "Some data is missing",
  behavior = "Files should be complete",
  data = c("specimenID", "assay"),
  type = ifelse(strict, "check_fail", "check_warn")
)
}
