% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{parse_drug_dosages}
\alias{parse_drug_dosages}
\title{Extracts the drug dosages element and return data as tibble.}
\usage{
parse_drug_dosages(save_table = FALSE)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}
}
\value{
drug dosages node attributes tibble
}
\description{
\code{parse_drug_dosages} returns tibble of drug dosages elements.
}
\details{
This functions extracts the dosages element of drug node in drugbank
xml database with the option to save it in a predefined database via
\code{\link{open_db}} method. It takes one single optional argument to
save the returned tibble in the database.
It must be called after \code{\link{get_xml_db_rows}} function like
any other parser function.
If \code{\link{get_xml_db_rows}} is called before for any reason, so
no need to call it again before calling this function.
}
\examples{
\donttest{
parse_drug_dosages()
parse_drug_dosages(TRUE)
parse_drug_dosages(save_table = FALSE)
}
}
