% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_dataset_json.R
\name{validate_dataset_json}
\alias{validate_dataset_json}
\title{Validate a Dataset JSON file}
\usage{
validate_dataset_json(x)
}
\arguments{
\item{x}{Path to a Dataset JSON file or a character vector holding JSON text}
}
\value{
A data frame
}
\description{
This function calls \code{jsonvalidate::json_validate()} directly, with the parameters
necessary to retrieve the error information of an invalid JSON file per the
Dataset JSON schema.
}
\examples{

\dontrun{
  validate_dataset_json('path/to/file.json')
}

ds_json <- dataset_json(iris, "IG.IRIS", "IRIS", "Iris", iris_items)
js <- write_dataset_json(ds_json)

validate_dataset_json(js)
}
