% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_generate_calls.R
\name{util_generate_calls}
\alias{util_generate_calls}
\title{Generate an execution/calling plan for computing a report from the metadata}
\usage{
util_generate_calls(
  dimensions,
  meta_data,
  label_col,
  meta_data_segment,
  meta_data_dataframe,
  meta_data_cross_item,
  specific_args,
  arg_overrides,
  resp_vars,
  filter_indicator_functions
)
}
\arguments{
\item{dimensions}{\link{dimensions} Vector of dimensions to address in the report.
Allowed values in the vector are Completeness, Consistency,
and Accuracy. The generated report will only cover the
listed data quality dimensions. Accuracy is computational
expensive, so this dimension is not enabled by default.
Completeness should be included, if Consistency is
included, and Consistency should be included, if Accuracy
is included to avoid misleading detections of e.g. missing
codes as outliers, please refer to the data quality concept
for more details. Integrity is always included.}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_dataframe}{\link{data.frame} -- optional: Data frame level
metadata}

\item{meta_data_cross_item}{\link{data.frame} -- optional: Cross-item level
metadata}

\item{specific_args}{\link{list} named list of arguments specifically for one of
the called functions, the of the list elements
correspond to the indicator functions whose calls
should be modified. The elements are lists of
arguments.}

\item{arg_overrides}{\link{list} arguments to be passed to all called indicator
functions if applicable.}

\item{resp_vars}{variables to be respected, \code{NULL} means to use all.}

\item{filter_indicator_functions}{\link{character} regular expressions, only
if an indicator function's name
matches one of these, it'll
be used for the report. If
of length zero, no filtering
is performed.}
}
\value{
a list of calls
}
\description{
Generate an execution/calling plan for computing a report from the metadata
}
\seealso{
Other reporting_functions: 
\code{\link{util_alias2caption}()},
\code{\link{util_copy_all_deps}()},
\code{\link{util_create_page_file}()},
\code{\link{util_eval_to_dataquieR_result}()},
\code{\link{util_evaluate_calls}()},
\code{\link{util_float_index_menu}()},
\code{\link{util_generate_anchor_link}()},
\code{\link{util_generate_anchor_tag}()},
\code{\link{util_generate_calls_for_function}()},
\code{\link{util_load_manual}()},
\code{\link{util_make_data_slot_from_table_slot}()},
\code{\link{util_make_function}()},
\code{\link{util_order_by_order}()},
\code{\link{util_set_size}()}
}
\concept{process}
\concept{reporting_functions}
\keyword{internal}
