% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_expect_scalar.R
\name{util_expect_scalar}
\alias{util_expect_scalar}
\title{check, if a scalar/vector function argument matches expectations}
\usage{
util_expect_scalar(
  arg_name,
  allow_more_than_one = FALSE,
  allow_null = FALSE,
  allow_na = FALSE,
  min_length = -Inf,
  max_length = Inf,
  check_type,
  convert_if_possible,
  dont_assign = FALSE
)
}
\arguments{
\item{arg_name}{the argument}

\item{allow_more_than_one}{allow vectors}

\item{allow_null}{allow NULL}

\item{allow_na}{allow \code{NAs}}

\item{min_length}{minimum length of the argument's value}

\item{max_length}{maximum length of the argument's value}

\item{check_type}{a predicate function, that must return \code{TRUE} on the
argument's value.}

\item{convert_if_possible}{if given, a lambda can be given
similar to \code{check_type} This
lambda would be used to try a conversion. If
a conversion fails (returns \code{NA}, where the
input was not `util_empty'), an error
is still thrown, the data is converted, otherwise}

\item{dont_assign}{set \code{TRUE} to keep \code{x} in the caller environment untouched}
}
\value{
the value of arg_name -- but this is updated in the calling
frame anyway.
}
\description{
check, if a scalar/vector function argument matches expectations
}
\examples{
\dontrun{
f <- function(x) {
  util_expect_scalar(x, check_type = is.integer)
}
f(42L)
try(f(42))
g <- function(x) {
  util_expect_scalar(x, check_type = is.integer, convert_if_possible =
          as.integer)
}
g(42L)
g(42)
}
}
