% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{chickgr}
\alias{chickgr}
\title{Chicken growth data.}
\format{
Contains four variables, as follows:
\describe{
\item{diet}{a factor with levels 1,2,3 and 4 indicating which experimental diet the chick received.}
\item{chick}{an ordered factor with levels different giving a unique identifier for the chick. The ordering of the
            levels groups chicks on the same diet together and orders them according to their final weight 
            (lightest to heaviest) within diet.}
  \item{time}{a numeric vector giving the number of days since birth when the measurement was made.}
  \item{weight}{a numeric vector giving the body weight of the chick, in gr.}
 }
}
\source{
The data were obtained from the 'alr4' library.
}
\usage{
data(chickgr)
}
\description{
Time series data. The body weights of the chicks were measured at birth and every second day thereafter until day 20. They were 
also measured on day 21. There were four groups on chicks on different protein diets.
}
\examples{
data(chickgr)    
head(chickgr)
library(lattice)
xyplot(weight~time|as.factor(diet), groups=as.factor(chick), type="b",data=chickgr) 
}
\references{
Crowder M, Hand D. 1990. Analysis of Repeated Measures. Chapman and Hall
}
\keyword{datasets}
