% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-copypaste.R
\name{import-copypaste}
\alias{import-copypaste}
\alias{import_copypaste_ui}
\alias{import_copypaste_server}
\title{Import data with copy & paste}
\usage{
import_copypaste_ui(id, title = TRUE, name_field = TRUE)

import_copypaste_server(
  id,
  btn_show_data = TRUE,
  show_data_in = c("popup", "modal"),
  trigger_return = c("button", "change"),
  return_class = c("data.frame", "data.table", "tbl_df"),
  reset = reactive(NULL),
  fread_args = list()
)
}
\arguments{
\item{id}{Module's ID.}

\item{title}{Module's title, if \code{TRUE} use the default title,
use \code{NULL} for no title or a \code{shiny.tag} for a custom one.}

\item{name_field}{Show or not a field to add a name to data (that is returned server-side).}

\item{btn_show_data}{Display or not a button to display data in a modal window if import is successful.}

\item{show_data_in}{Where to display data: in a \code{"popup"} or in a \code{"modal"} window.}

\item{trigger_return}{When to update selected data:
\code{"button"} (when user click on button) or
\code{"change"} (each time user select a dataset in the list).}

\item{return_class}{Class of returned data: \code{data.frame}, \code{data.table} or \code{tbl_df} (tibble).}

\item{reset}{A \code{reactive} function that when triggered resets the data.}

\item{fread_args}{\code{list} of additional arguments to pass to \code{\link[data.table:fread]{data.table::fread()}} when reading data.}
}
\value{
\itemize{
\item UI: HTML tags that can be included in shiny's UI
\item Server: a \code{list} with three slots:
\itemize{
\item \strong{status}: a \code{reactive} function returning the status: \code{NULL}, \code{error} or \code{success}.
\item \strong{name}: a \code{reactive} function returning the name of the imported data as \code{character}.
\item \strong{data}: a \code{reactive} function returning the imported \code{data.frame}.
}
}
}
\description{
Let the user copy data from Excel or text file then paste it into a text area to import it.
}
\examples{

library(shiny)
library(datamods)

ui <- fluidPage(
  tags$h3("Import data with copy & paste"),
  fluidRow(
    column(
      width = 4,
      import_copypaste_ui("myid")
    ),
    column(
      width = 8,
      tags$b("Import status:"),
      verbatimTextOutput(outputId = "status"),
      tags$b("Name:"),
      verbatimTextOutput(outputId = "name"),
      tags$b("Data:"),
      verbatimTextOutput(outputId = "data")
    )
  )
)

server <- function(input, output, session) {

  imported <- import_copypaste_server("myid")

  output$status <- renderPrint({
    imported$status()
  })
  output$name <- renderPrint({
    imported$name()
  })
  output$data <- renderPrint({
    imported$data()
  })

}

if (interactive())
  shinyApp(ui, server)
}
