% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombine_combine.R
\name{combDdo}
\alias{combDdo}
\title{"DDO" Recombination}
\usage{
combDdo(...)
}
\arguments{
\item{\ldots}{additional attributes to define the combiner (currently only used internally)}
}
\description{
"DDO" recombination - simply collect the results into a "ddo" object
}
\details{
\code{combDdo} is passed to the argument \code{combine} in \code{\link{recombine}}
}
\examples{
# Divide the iris data
bySpecies <- divide(iris, by = "Species")

# Add a transform that returns a list for each subset
listTrans <- function(x) {
  list(meanPetalWidth = mean(x$Petal.Width),
       maxPetalLength = max(x$Petal.Length))
}

# Apply the transform and combine using combDdo
combined <- recombine(addTransform(bySpecies, listTrans), combine = combDdo)
combined
combined[[1]]

# A more concise (and readable) way to do it
bySpecies \%>\%
  addTransform(listTrans) \%>\%
  recombine(combDdo)
}
\author{
Ryan Hafen
}
\seealso{
\code{\link{divide}}, \code{\link{recombine}}, \code{\link{combCollect}}, \code{\link{combMeanCoef}}, \code{\link{combRbind}}, \code{\link{combMean}}
}

