% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darch.R
\name{darch}
\alias{darch}
\alias{darch.DataSet}
\alias{darch.default}
\alias{darch.formula}
\title{Fit a deep neural network}
\usage{
darch(x, ...)

\method{darch}{default}(x, y, layers = 10, ..., autosave = F,
  autosave.epochs = round(darch.numEpochs/20),
  autosave.dir = "./darch.autosave", autosave.trim = F, bp.learnRate = 1,
  bp.learnRateScale = 1, bootstrap = F, bootstrap.unique = T,
  bootstrap.num = 0, cg.length = 2, cg.switchLayers = 1, darch = NULL,
  darch.batchSize = 1, darch.dither = F, darch.dropout = 0,
  darch.dropout.dropConnect = F, darch.dropout.momentMatching = 0,
  darch.dropout.oneMaskPerEpoch = F, darch.elu.alpha = 1,
  darch.errorFunction = if (darch.isClass) crossEntropyError else mseError,
  darch.finalMomentum = 0.9, darch.fineTuneFunction = backpropagation,
  darch.initialMomentum = 0.5, darch.isClass = T,
  darch.maxout.poolSize = 2, darch.maxout.unitFunction = linearUnit,
  darch.momentumRampLength = 1, darch.nesterovMomentum = T,
  darch.numEpochs = 100, darch.returnBestModel = T,
  darch.returnBestModel.validationErrorFactor = 1 - exp(-1),
  darch.stopClassErr = -Inf, darch.stopErr = -Inf,
  darch.stopValidClassErr = -Inf, darch.stopValidErr = -Inf,
  darch.trainLayers = T, darch.unitFunction = sigmoidUnit,
  darch.weightDecay = 0,
  darch.weightUpdateFunction = weightDecayWeightUpdate, dataSet = NULL,
  dataSetValid = NULL,
  generateWeightsFunction = generateWeightsGlorotUniform, gputools = F,
  gputools.deviceId = 0, logLevel = NULL, normalizeWeights = F,
  normalizeWeightsBound = 15, paramsList = list(),
  preProc.factorToNumeric = F, preProc.factorToNumeric.targets = F,
  preProc.fullRank = T, preProc.fullRank.targets = F,
  preProc.orderedToFactor.targets = T, preProc.params = F,
  preProc.targets = F, rbm.allData = F, rbm.batchSize = 1,
  rbm.consecutive = T, rbm.errorFunction = mseError,
  rbm.finalMomentum = 0.9, rbm.initialMomentum = 0.5, rbm.lastLayer = 0,
  rbm.learnRate = 1, rbm.learnRateScale = 1, rbm.momentumRampLength = 1,
  rbm.numCD = 1, rbm.numEpochs = 0, rbm.unitFunction = sigmoidUnitRbm,
  rbm.updateFunction = rbmUpdate, rbm.weightDecay = 2e-04, retainData = F,
  rprop.decFact = 0.5, rprop.incFact = 1.2, rprop.initDelta = 1/80,
  rprop.maxDelta = 50, rprop.method = "iRprop+", rprop.minDelta = 1e-06,
  seed = NULL, shuffleTrainData = T, weights.max = 0.1,
  weights.mean = 0, weights.min = -0.1, weights.sd = 0.01,
  xValid = NULL, yValid = NULL)

\method{darch}{formula}(x, data, layers, ..., xValid = NULL, dataSet = NULL,
  dataSetValid = NULL, logLevel = NULL, paramsList = list(),
  darch = NULL)

\method{darch}{DataSet}(x, ...)
}
\arguments{
\item{x}{Input data matrix or \code{\link{data.frame}}
(\code{darch.default}) or \code{\link{formula}} (\code{darch.formula}) or
\code{\linkS4class{DataSet}} (\code{darch.DataSet}).}

\item{...}{Additional parameters.}

\item{y}{Target data matrix or \code{\link{data.frame}}, if \code{x} is an
input data matrix or \code{\link{data.frame}}.}

\item{layers}{Vector containing one integer for the number of neurons of
each layer. Defaults to c(\code{a}, 10, \code{b}), where \code{a} is the
number of columns in the training data and \code{b} the number of columns
in the targets. If this has length 1, it is used as the number of neurons
in the hidden layer, not as the number of layers!}

\item{autosave}{Logical indicating whether to activate automatically saving
the \code{\linkS4class{DArch}} instance to a file during fine-tuning.}

\item{autosave.epochs}{After how many epochs should auto-saving happen, by
default after every 5% of overall progress. If this number is smaller than
1, the network will only be saved once when thee fine-tuning is done.}

\item{autosave.dir}{Directory for the autosave files, the file names will be
e.g. autosave_010.net for the DArch instance after 10 epochs}

\item{autosave.trim}{Whether to trim the network before saving it. This will
remove the dataset and the layer weights, resulting in a network that is
no longer usable for predictions or training. Useful when only statistics
and settings need to be stored.}

\item{bp.learnRate}{Learning rates for backpropagation, length is either one
or the same as the number of weight matrices when using different learning
rates for each layer.}

\item{bp.learnRateScale}{The learn rate is multiplied by this value after
each epoch.}

\item{bootstrap}{Logical indicating whether to use bootstrapping to
create a training and validation data set from the given training data.}

\item{bootstrap.unique}{Logical indicating whether to take only unique
samples for the training (\code{TRUE}, default) or take all drawn
samples (\code{FALSE}), which will results in a bigger training set with
duplicates. \strong{Note:} This is ignored if \code{bootstrap.num} is
greater than 0.}

\item{bootstrap.num}{If this is greater than 0, bootstrapping will draw this
number of training samples without replacement.}

\item{cg.length}{Numbers of line search}

\item{cg.switchLayers}{Indicates when to train the full network instead of
only the upper two layers}

\item{darch}{Existing \code{\linkS4class{DArch}} instance for which training
is to be resumed. \strong{Note:} When enabling pre-training, previous
training results we be lost, see explanation for parameter
\code{rbm.numEpochs}.}

\item{darch.batchSize}{Batch size, i.e. the number of training samples that
are presented to the network before weight updates are performed, for
fine-tuning.}

\item{darch.dither}{Whether to apply
\href{http://arxiv.org/abs/1508.04826}{dither} to numeric columns in the
training input data.}

\item{darch.dropout}{Dropout rates. If this is a vector it will be treated
as the dropout rates for each individual layer. If one element is missing,
the input dropout will be set to 0. When enabling
\code{darch.dropout.dropConnect}, this vector needs an additional element
(one element per weight matrix between two layers as opposed to one
element per layer excluding the last layer).}

\item{darch.dropout.dropConnect}{Whether to use DropConnect instead of
dropout for the hidden layers. Will use \code{darch.dropout} as the
dropout rates.}

\item{darch.dropout.momentMatching}{How many iterations to perform during
moment matching for dropout inference, 0 to disable moment matching.}

\item{darch.dropout.oneMaskPerEpoch}{Whether to generate a new mask for each
batch (\code{FALSE}, default) or for each epoch (\code{TRUE}).}

\item{darch.elu.alpha}{Alpha parameter for the exponential linear unit
function. See \code{\link{exponentialLinearUnit}}.}

\item{darch.errorFunction}{Error function during fine-tuning. Possible error
functions include \code{\link{mseError}},\code{\link{rmseError}}, and
\code{\link{crossEntropyError}}.}

\item{darch.finalMomentum}{Final momentum during fine-tuning.}

\item{darch.fineTuneFunction}{Fine-tuning function. Possible values include
\code{\link{backpropagation}} (default), \code{\link{rpropagation}},
\code{\link{minimizeClassifier}} and \code{\link{minimizeAutoencoder}}
(unsupervised).}

\item{darch.initialMomentum}{Initial momentum during fine-tuning.}

\item{darch.isClass}{Whether output should be treated as class labels
during fine-tuning and classification rates should be printed.}

\item{darch.maxout.poolSize}{Pool size for maxout units, when
using the maxout acitvation function. See \code{\link{maxoutUnit}}.}

\item{darch.maxout.unitFunction}{Inner unit function used by maxout. See
\code{darch.unitFunction} for possible unit functions.}

\item{darch.momentumRampLength}{After how many epochs, relative to
the \strong{overall} number of epochs trained, should the momentum reach
\code{darch.finalMomentum}?
A value of 1 indicates that the \code{darch.finalMomentum} should be
reached in the final epoch, a value of 0.5 indicates that
\code{darch.finalMomentum} should be reached after half of the training is
complete. Note that this will lead to bumps in the momentum ramp if
training is resumed with the same parameters for
\code{darch.initialMomentum} and \code{darch.finalMomentum}. Set
\code{darch.momentumRampLength} to 0 to avoid this problem when resuming
training.}

\item{darch.nesterovMomentum}{Whether to use
\href{https://cs231n.github.io/neural-networks-3/#sgd}{Nesterov Accelerated Momentum}.
(NAG) for gradient descent based fine-tuning algorithms.}

\item{darch.numEpochs}{Number of epochs of fine-tuning.}

\item{darch.returnBestModel}{Logical indicating whether to return the best
model at the end of training, instead of the last.}

\item{darch.returnBestModel.validationErrorFactor}{When evaluating models
with validation data, how high should the validation error be valued,
compared to the training error? This is a value between 0 and 1. By
default, this value is \code{1 - exp(-1)}. The training error factor
and the validation error factor will always add to 1, so if you pass 1
here, the training error will be ignored, and if you pass 0 here, the
validation error will be ignored.}

\item{darch.stopClassErr}{When the classification error is lower than or
equal to this value, training is stopped (0..100).}

\item{darch.stopErr}{When the value of the error function is lower than or
equal to this value, training is stopped.}

\item{darch.stopValidClassErr}{When the classification error on the
validation data is lower than or equal to this value, training is stopped
(0..100).}

\item{darch.stopValidErr}{When the value of the error function on the
validation data is lower than or equal to this value, training is stopped.}

\item{darch.trainLayers}{Either TRUE to train all layers or a mask containing
TRUE for all layers which should be trained and FALSE for all layers that
should not be trained (no entry for the input layer).}

\item{darch.unitFunction}{Layer function or vector of layer functions of
length \code{number of layers} - 1. Note that the first entry signifies
the layer function between layers 1 and 2, i.e. the output of layer 2.
Layer 1 does not have a layer function, since the input values are used
directly. Possible unit functions include \code{\link{linearUnit}},
\code{\link{sigmoidUnit}}, \code{\link{tanhUnit}},
\code{\link{rectifiedLinearUnit}}, \code{\link{softplusUnit}},
\code{\link{softmaxUnit}}, and \code{\link{maxoutUnit}}.}

\item{darch.weightDecay}{Weight decay factor, defaults to \code{0}. All
weights will be multiplied by (1 - \code{darch.weightDecay}) prior to each
weight update.}

\item{darch.weightUpdateFunction}{Weight update function or vector of weight
update functions, very similar to \code{darch.unitFunction}. Possible
weight update functions include \code{\link{weightDecayWeightUpdate}} and
\code{\link{maxoutWeightUpdate}} Note that \code{\link{maxoutWeightUpdate}}
must be used on the layer \strong{after} the maxout activation function!}

\item{dataSet}{\code{\linkS4class{DataSet}} instance, passed from
darch.DataSet(), may be specified manually.}

\item{dataSetValid}{\code{\linkS4class{DataSet}} instance containing
validation data.}

\item{generateWeightsFunction}{Weight generation function or vector of layer
generation functions of length \code{number of layers} - 1. Possible
weight generation functions include \code{\link{generateWeightsUniform}}
(default), \code{\link{generateWeightsNormal}},
\code{\link{generateWeightsGlorotNormal}},
\code{\link{generateWeightsGlorotUniform}},
\code{\link{generateWeightsHeNormal}}, and
\code{\link{generateWeightsHeUniform}}.}

\item{gputools}{Logical indicating whether to use gputools for matrix
multiplication, if available.}

\item{gputools.deviceId}{Integer specifying the device to use for GPU
matrix multiplication. See \code{\link[gputools]{chooseGpu}}.}

\item{logLevel}{\code{\link{futile.logger}} log level. Uses the currently
set log level by default, which is \code{futile.logger::flog.info} if it
was not changed. Other available levels include, from least to most
verbose: \code{FATAL}, \code{ERROR}, \code{WARN}, \code{DEBUG}, and
\code{TRACE}.}

\item{normalizeWeights}{Logical indicating whether to normalize weights (L2
norm = \code{normalizeWeightsBound}).}

\item{normalizeWeightsBound}{Upper bound on the L2 norm of incoming weight
vectors. Used only if \code{normalizeWeights} is \code{TRUE}.}

\item{paramsList}{List of parameters, can include and does overwrite
specified parameters listed above. Primary for convenience or for use in
scripts.}

\item{preProc.factorToNumeric}{Whether all factors should be converted to
numeric.}

\item{preProc.factorToNumeric.targets}{Whether all factors should be
converted to numeric in the target data.}

\item{preProc.fullRank}{Whether to use full rank encoding. See
\link[caret]{preProcess} for details.}

\item{preProc.fullRank.targets}{Whether to use full rank encoding for target
data. See \link[caret]{preProcess} for details.}

\item{preProc.orderedToFactor.targets}{Whether ordered factors in the target
data should be converted to unordered factors. \strong{Note:} Ordered
factors are converted to numeric by \code{\link[caret]{dummyVars}} and no
longer usable for classification tasks.}

\item{preProc.params}{List of parameters to pass to the
\code{\link[caret]{preProcess}} function for the input data or
\code{FALSE} to disable input data pre-processing.}

\item{preProc.targets}{Whether target data is to be centered and
scaled. Unlike \code{preProc.params}, this is just a logical
turning pre-processing for target data on or off, since this
pre-processing has to be reverted when predicting new data. Most useful
for regression tasks. \strong{Note:} This will skew the raw network error.}

\item{rbm.allData}{Logical indicating whether to use training and validation
data for pre-training. \strong{Note:} This also applies when using
bootstrapping.}

\item{rbm.batchSize}{Pre-training batch size.}

\item{rbm.consecutive}{Logical indicating whether to train the RBMs one at
a time for \code{rbm.numEpochs} epochs (\code{TRUE}, default) or
alternatingly training each RBM for one epoch at a time (\code{FALSE}).}

\item{rbm.errorFunction}{Error function during pre-training. This is only
used to estimate the RBM error and does not affect the training itself.
Possible error functions include \code{\link{mseError}} and
\code{\link{rmseError}}.}

\item{rbm.finalMomentum}{Final momentum during pre-training.}

\item{rbm.initialMomentum}{Initial momentum during pre-training.}

\item{rbm.lastLayer}{\code{Numeric} indicating at which layer to stop the
pre-training. Possible values include \code{0}, meaning that all layers
are trained; positive integers, meaning to stop training after the RBM
where \code{rbm.lastLayer} forms the visible layer; negative integers,
meaning to stop the training at \code{rbm.lastLayer} RBMs from the top
RBM.}

\item{rbm.learnRate}{Learning rate during pre-training.}

\item{rbm.learnRateScale}{The learn rates will be multiplied with this
value after each epoch.}

\item{rbm.momentumRampLength}{After how many epochs, relative to
\code{rbm.numEpochs}, should the momentum reach \code{rbm.finalMomentum}?
A value of 1 indicates that the \code{rbm.finalMomentum} should be reached
in the final epoch, a value of 0.5 indicates that \code{rbm.finalMomentum}
should be reached after half of the training is complete.}

\item{rbm.numCD}{Number of full steps for which contrastive divergence is
performed. Increasing this will slow training down considerably.}

\item{rbm.numEpochs}{Number of pre-training epochs. \strong{Note:} When
passing a value other than \code{0} here and also passing an existing
\code{\linkS4class{DArch}} instance via the \code{darch} parameter, the
weights of the network will be completely reset!
Pre-training is essentially a
form of advanced weight initialization and it makes no sense to perform
pre-training on a previously trained network.}

\item{rbm.unitFunction}{Unit function during pre-training. Possible
functions include \code{\link{sigmoidUnitRbm}} (default),
\code{\link{tanhUnitRbm}}, and \code{\link{linearUnitRbm}}.}

\item{rbm.updateFunction}{Update function during pre-training. Currently,
\code{darch} only provides \code{\link{rbmUpdate}}.}

\item{rbm.weightDecay}{Pre-training weight decay. Weights will be multiplied
by (1 - \code{rbm.weightDecay}) prior to each weight update.}

\item{retainData}{Logical indicating whether to store the training
data in the \code{\linkS4class{DArch}} instance after training or when
saving it to disk.}

\item{rprop.decFact}{Decreasing factor for the training. Default is \code{0.6}.}

\item{rprop.incFact}{Increasing factor for the training Default is \code{1.2}.}

\item{rprop.initDelta}{Initialisation value for the update. Default is \code{0.0125}.}

\item{rprop.maxDelta}{Upper bound for step size. Default is \code{50}}

\item{rprop.method}{The method for the training. Default is "iRprop+"}

\item{rprop.minDelta}{Lower bound for step size. Default is \code{0.000001}}

\item{seed}{Allows the specification of a seed which will be set via
\code{\link{set.seed}}. Used in the context of \code{\link{darchBench}}.}

\item{shuffleTrainData}{Logical indicating whether to shuffle training data
before each epoch.}

\item{weights.max}{\code{max} parameter to the \link{runif} function.}

\item{weights.mean}{\code{mean} parameter to the \link{rnorm} function.}

\item{weights.min}{\code{min} parameter to the \link{runif} function.}

\item{weights.sd}{\code{sd} parameter to the \link{rnorm} function.}

\item{xValid}{Validation input data matrix or \code{\link{data.frame}}.}

\item{yValid}{Validation target data matrix or \code{\link{data.frame}}, if
\code{x} is a data matrix or \code{\link{data.frame}}.}

\item{data}{\code{\link{data.frame}} containing the dataset, if \code{x} is
a \code{\link{formula}}.}
}
\value{
Fitted \code{\linkS4class{DArch}} instance
}
\description{
Fit a deep neural network with optional pre-training and one of various
fine-tuning algorithms.
}
\details{
The darch package implements Deep Architecture Networks and restricted
Boltzmann machines.

The creation of this package is motivated by the papers from G. Hinton et.
al. from 2006 (see references for details) and from the MATLAB source code
developed in this context. This package provides the possibility to generate
deep architecture networks (darch) like the deep belief networks from Hinton
et. al.. The deep architectures can then be trained with the contrastive
divergence method. After this pre-training it can be fine tuned with several
learning methods like backpropagation, resilient backpropagation and
conjugate gradients as well as more recent techniques like dropout and
maxout.

See \url{https://github.com/maddin79/darch} for further information,
documentation, and releases.

\tabular{ll}{ Package: \tab darch\cr Type: \tab Package\cr Version: \tab
0.10.0\cr Date: \tab 2015-11-12\cr License: \tab GPL-2 or later\cr
LazyLoad: \tab yes\cr }
}
\examples{
\dontrun{
data(iris)
model <- darch(Species ~ ., iris)
print(model)
predictions <- predict(model, newdata = iris, type = "class")
cat(paste("Incorrect classifications:", sum(predictions != iris[,5])))

trainData <- matrix(c(0,0,0,1,1,0,1,1), ncol = 2, byrow = TRUE)
trainTargets <- matrix(c(0,1,1,0), nrow = 4)
model2 <- darch(trainData, trainTargets, layers = c(2, 10, 1),
  darch.numEpochs = 500, darch.stopClassErr = 0, retainData = T)
e <- darchTest(model2)
cat(paste0("Incorrect classifications on all examples: ", e[3], " (",
  e[2], "\%)\\n"))

plot(model2)
}

#
# More examples can be found at
# https://github.com/maddin79/darch/tree/v0.12.0/examples
}
\author{
Martin Drees \email{mdrees@stud.fh-dortmund.de} and contributors.
}
\references{
Hinton, G. E., S. Osindero, Y. W. Teh, A fast learning algorithm
  for deep belief nets, Neural Computation 18(7), S. 1527-1554, DOI:
  10.1162/neco.2006.18.7.1527 2006.

  Hinton, G. E., R. R. Salakhutdinov, Reducing the dimensionality of data
  with neural networks, Science 313(5786), S. 504-507, DOI:
  10.1126/science.1127647, 2006.

  Hinton, Geoffrey E. et al. (2012). "Improving neural networks by
  preventing coadaptation of feature detectors". In: Clinical Orthopaedics
  and Related Research abs/1207.0580. URL : http://arxiv.org/abs/1207.0580.

  Goodfellow, Ian J. et al. (2013). "Maxout Networks". In: Proceedings of
  the 30th International Conference on Machine Learning, ICML 2013, Atlanta,
  GA, USA, 16-21 June 2013, pp. 1319-1327.
  URL: http://jmlr.org/proceedings/papers/v28/goodfellow13.html.

  Drees, Martin (2013). "Implementierung und Analyse von tiefen Architekturen
  in R". German. Master's thesis. Fachhochschule Dortmund.

  Rueckert, Johannes (2015). "Extending the Darch library for deep
  architectures". Project thesis. Fachhochschule Dortmund.
  URL: http://static.saviola.de/publications/rueckert_2015.pdf.
}
\seealso{
Other darch interface functions: \code{\link{darchBench}},
  \code{\link{darchTest}}, \code{\link{plot.DArch}},
  \code{\link{predict.DArch}}, \code{\link{print.DArch}}
}

