% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/send_to_dai.R
\name{dai_sync_tab}
\alias{dai_sync_tab}
\title{OCR synchronously and get table data}
\usage{
dai_sync_tab(file, proj_id = get_project_id(), loc = "eu", token = dai_token())
}
\arguments{
\item{file}{path to a single pdf or image file}

\item{proj_id}{a GCS project id}

\item{loc}{a two-letter region code ("eu" or "us")}

\item{token}{An access token generated by \code{dai_auth()} or another
auth function.}
}
\value{
a HTTP response object
}
\description{
Sends a single document to the Google Cloud Services (GCS)
Document AI v1beta2 API for synchronous (immediate) processing. Returns
a response object containing the OCRed text and additional information,
including table-related data.
}
\details{
This function accesses a different API endpoint than the main
\code{dai_sync()} function, one that has less language support, but
returns table data in addition to parsed text (which \code{dai_sync()}
currently does not). This function may be deprecated if/when the v1
endpoint incorporates table extraction. Use of this service requires
a GCS access token and some configuration of the .Renviron file; see
vignettes for details. Input files can be in either .pdf, .bmp, .gif,
.jpeg, .jpg, .png, or .tiff format. PDFs can be up to five pages long.
Extract the text from the response object with
\code{text_from_dai_response()}. Inspect the entire response object
with \code{httr::content()}.
}
\examples{
\dontrun{
response <- dai_sync("doc_page.pdf")

my_page_scan <- "001.png"
response <- dai_sync(my_page_scan)
}
}
