% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/d3heatmap.R
\name{d3heatmap}
\alias{d3heatmap}
\title{D3 Heatmap widget}
\source{
The interface was designed based on \link{heatmap} and \link[gplots]{heatmap.2}
}
\usage{
d3heatmap(x, Rowv = TRUE, Colv = if (symm) "Rowv" else TRUE,
  distfun = dist, hclustfun = hclust, dendrogram = c("both", "row",
  "column", "none"), reorderfun = function(d, w) reorder(d, w), k_row, k_col,
  symm = FALSE, revC, scale = c("none", "row", "column"), na.rm = TRUE,
  labRow = rownames(x), labCol = colnames(x), cexRow, cexCol, digits = 3L,
  cellnote, cellnote_scale = FALSE, theme = NULL, colors = "RdYlBu",
  width = NULL, height = NULL, xaxis_height = 80, yaxis_width = 120,
  xaxis_font_size = NULL, yaxis_font_size = NULL, brush_color = "#0000FF",
  show_grid = TRUE, anim_duration = 500, ...)
}
\arguments{
\item{x}{A numeric matrix
Defaults to \code{TRUE} unless \code{x} contains any \code{NA}s.}

\item{Rowv}{determines if and how the row dendrogram should be reordered.    By default, it is TRUE, which implies dendrogram is computed and reordered based on row means. If NULL or FALSE, then no dendrogram is computed and no reordering is done. If a dendrogram, then it is used "as-is", ie without any reordering. If a vector of integers, then dendrogram is computed and reordered based on the order of the vector.}

\item{Colv}{determines if and how the column dendrogram should be reordered.    Has the options as the Rowv argument above and additionally when x is a square matrix, Colv = "Rowv" means that columns should be treated identically to the rows.}

\item{distfun}{function used to compute the distance (dissimilarity) between both rows and columns. Defaults to dist.}

\item{hclustfun}{function used to compute the hierarchical clustering when Rowv or Colv are not dendrograms. Defaults to hclust.}

\item{dendrogram}{character string indicating whether to draw 'none', 'row', 'column' or 'both' dendrograms. Defaults to 'both'. However, if Rowv (or Colv) is FALSE or NULL and dendrogram is 'both', then a warning is issued and Rowv (or Colv) arguments are honoured.}

\item{reorderfun}{function(d, w) of dendrogram and weights for reordering the row and column dendrograms. The default uses stats{reorder.dendrogram}}

\item{k_row}{an integer scalar with the desired number of groups by which to color the dendrogram's branches in the rows (uses \link[dendextend]{color_branches})}

\item{k_col}{an integer scalar with the desired number of groups by which to color the dendrogram's branches in the columns (uses \link[dendextend]{color_branches})}

\item{symm}{logical indicating if x should be treated symmetrically; can only be true when x is a square matrix.}

\item{revC}{logical indicating if the column order should be reversed for plotting.
Default (when missing) - is FALSE, unless symm is TRUE.
This is useful for cor matrix.}

\item{scale}{character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. The default is "none".}

\item{na.rm}{logical indicating whether NA's should be removed.}

\item{labRow}{character vectors with row labels to use (from top to bottom); default to rownames(x).}

\item{labCol}{character vectors with column labels to use (from left to right); default to colnames(x).}

\item{cexRow}{positive numbers. If not missing, it will override \code{xaxis_font_size}
and will give it a value cexRow*14}

\item{cexCol}{positive numbers. If not missing, it will override \code{yaxis_font_size}
and will give it a value cexCol*14}

\item{digits}{integer indicating the number of decimal places to be used by \link{round} for 'label'.}

\item{cellnote}{(optional) matrix of the same dimensions as \code{x} that has the human-readable version of each value, for displaying to the user on hover. If \code{NULL}, then \code{x} will be coerced using \code{\link{as.character}}.
If missing, it will use \code{x}, after rounding it based on the \code{digits} parameter.}

\item{cellnote_scale}{logical (default is FALSE). IF cellnote is missing and x is used,
should cellnote be scaled if x is also scaled?}

\item{theme}{A custom CSS theme to use. Currently the only valid values are
\code{""} and \code{"dark"}. \code{"dark"} is primarily intended for
standalone visualizations, not R Markdown or Shiny.}

\item{colors}{Either a colorbrewer2.org palette name (e.g. \code{"YlOrRd"} or
\code{"Blues"}), or a vector of colors to interpolate in hexadecimal
\code{"#RRGGBB"} format, or a color interpolation function like
\code{\link[grDevices]{colorRamp}}.}

\item{width}{Width in pixels (optional, defaults to automatic sizing).}

\item{height}{Height in pixels (optional, defaults to automatic sizing).}

\item{xaxis_height}{Size of axes, in pixels.}

\item{yaxis_width}{Size of axes, in pixels.}

\item{xaxis_font_size}{Font size of axis labels, as a CSS size (e.g. "14px" or "12pt").}

\item{yaxis_font_size}{Font size of axis labels, as a CSS size (e.g. "14px" or "12pt").}

\item{brush_color}{The base color to be used for the brush. The brush will be
filled with a low-opacity version of this color. \code{"#RRGGBB"} format
expected.}

\item{show_grid}{\code{TRUE} to show gridlines, \code{FALSE} to hide them, or
a numeric value to specify the gridline thickness in pixels (can be a
non-integer).}

\item{anim_duration}{Number of milliseconds to animate zooming in and out.
  For large \code{x} it may help performance to set this value to \code{0}.}

\item{...}{currently ignored}
}
\description{
Creates a D3.js-based heatmap widget.
}
\examples{
library(d3heatmap)
d3heatmap(mtcars, scale = "column", colors = "Blues")
}
\seealso{
\link{heatmap}, \link[gplots]{heatmap.2}
}

