% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cytopop.R
\name{plot_cytopop}
\alias{plot_cytopop}
\title{Plot the cell count for each population using CytomeTree.}
\usage{
plot_cytopop(AnnotObj, nbpop = 10, mincount = 1, maxcount = NULL,
  y_axis = c("abs_count", "prop"))
}
\arguments{
\item{AnnotObj}{An object of class Annotation.}

\item{nbpop}{Number indicating the maximum of population plotted.
Default is \code{10}}

\item{mincount}{Number indicating the minimum of cell count
for the populations. Default is \code{1}.}

\item{maxcount}{Number indicating the maximum of cell count
for the populations. Default is \code{NULL} i.e no maximum selected.}

\item{y_axis}{a character string either \code{"abs_count"} or \code{"prop"} indicating 
whether the absolute cell count or the relative populations proportions should be plotted.
Default is \code{"abs_count"}.}
}
\description{
Plot the cell count for each population using CytomeTree.
}
\examples{

# Run CytomeTree
data(DLBCL)
cellevents <- DLBCL[,c("FL1", "FL2", "FL4")]
Tree <- CytomeTree(cellevents, minleaf = 1, t=.1)
Annot <- Annotation(Tree,plot=FALSE)

# Plot the cell count
plot_cytopop(Annot)
}
\author{
Anthony Devaux, Boris Hejblum
}
