% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openssl.R
\name{key_openssl}
\alias{key_openssl}
\title{Symmetric encryption with openssl}
\usage{
key_openssl(key, mode = "cbc")
}
\arguments{
\item{key}{An openssl aes key (i.e., an object of class \code{aes}).}

\item{mode}{The encryption mode to use.  Options are \code{cbc},
\code{ctr} and \code{gcm} (see the \code{openssl} package for
more details)}
}
\description{
Wrap an openssl symmetric (aes) key.  This can be used with the
functions \code{\link[=encrypt_data]{encrypt_data()}} and
\code{\link[=decrypt_data]{decrypt_data()}}, along with the higher level wrappers
\code{\link[=encrypt]{encrypt()}} and \code{\link[=decrypt]{decrypt()}}.  With a symmetric
key, everybody uses the same key for encryption and decryption.
}
\examples{
# Create a new key
key <- cyphr::key_openssl(openssl::aes_keygen())
key

# With this key encrypt a string
secret <- cyphr::encrypt_string("my secret string", key)
# And decrypt it again:
cyphr::decrypt_string(secret, key)
}
