% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt_data.R
\name{encrypt_data}
\alias{encrypt_data}
\alias{encrypt_object}
\alias{encrypt_string}
\alias{encrypt_file}
\alias{decrypt_data}
\alias{decrypt_object}
\alias{decrypt_string}
\alias{decrypt_file}
\title{Encrypt and decrypt data and other things}
\usage{
encrypt_data(data, key, dest = NULL)

encrypt_object(object, key, dest = NULL, rds_version = NULL)

encrypt_string(string, key, dest = NULL)

encrypt_file(path, key, dest = NULL)

decrypt_data(data, key, dest = NULL)

decrypt_object(data, key)

decrypt_string(data, key)

decrypt_file(path, key, dest = NULL)
}
\arguments{
\item{data}{(for \code{encrypt_data}, \code{decrypt_data},
\code{decrypt_object}, \code{decrypt_string}) a raw vector with
the data to be encrypted or decrypted.  For the decryption
functions this must be data derived by encrypting something or
you will get an error.}

\item{key}{A \code{cyphr_key} or \code{cyphr_key} object
describing the encryption approach to use.}

\item{dest}{The destination filename for the encrypted or
decrypted data, or \code{NULL} to return a raw vector.  This is
not used by \code{decrypt_object} or \code{decrypt_string} which
always return an object or string.}

\item{object}{(for \code{encrypt_object}) an arbitrary R object to
encrypt.  It will be serialised to raw first (see
\code{\link{serialize}}).}

\item{rds_version}{RDS serialisation version to use (see
\code{\link{serialize}}.  The default in R version 3.3 and below
is version 2 - in the R 3.4 series version 3 was introduced and
is becoming the default.  Version 3 format serialisation is not
understood by older versions so if you need to exchange data
with older R versions, you will need to use \code{rds_version =
2}.  The default argument here (\code{NULL}) will ensure the
same serialisation is used as R would use by default.}

\item{string}{(for \code{encrypt_string}) a scalar character
vector to encrypt.  It will be converted to raw first with
\code{\link{charToRaw}}.}

\item{path}{(for \code{encrypt_file}) the name of a file to
encrypt.  It will first be read into R as binary (see
\code{\link{readBin}}).}
}
\description{
Encrypt and decrypt raw data, objects, strings and files.  The
core functions here are \code{encrypt_data} and
\code{decrypt_data} which take raw data and decrypt it, writing
either to file or returning a raw vector.  The other functions
encrypt and decrypt arbitrary R objects (\code{encrypt_object},
\code{decrypt_object}), strings (\code{encrypt_string},
\code{decrypt_string}) and files (\code{encrypt_file},
\code{decrypt_file}).
}
\examples{
key <- key_sodium(sodium::keygen())
# Some super secret data we want to encrypt:
x <- runif(10)
# Convert the data into a raw vector:
data <- serialize(x, NULL)
data
# Encrypt the data; without the key above we will never be able to
# decrypt this.
data_enc <- encrypt_data(data, key)
data_enc
# Our random numbers:
unserialize(decrypt_data(data_enc, key))
# Same as the never-encrypted version:
x

# This can be achieved more easily using `encrypt_object`:
data_enc <- encrypt_object(x, key)
identical(decrypt_object(data_enc, key), x)

# Encrypt strings easily:
str_enc <- encrypt_string("secret message", key)
str_enc
decrypt_string(str_enc, key)
}
